#include "enemy.h"

Enemy *new_enemy()
{
	Enemy *self = (Enemy*) malloc(sizeof(Enemy));
	
	self->pos.x = 20;
	self->pos.y = 100;
	self->pos.h = 40;
	self->pos.w = 40;
	
	self->surface = SDL_LoadBMP("persoAlan2.bmp");
	if (self->surface)
	{
		printf("Chargement de l'image\n");
	}
	else 
	{
		printf("Erreur : %s\n", SDL_GetError());
	}
	SDL_SetColorKey(self->surface, SDL_TRUE, SDL_MapRGB(self->surface->format, 255, 255, 255));
	return self;
}

void Enemy_display(Enemy *self, SDL_Renderer *renderer)
{
	SDL_Texture *texture = SDL_CreateTextureFromSurface(renderer, self->surface);
	SDL_RenderCopy(renderer, texture, NULL, &self->pos);
	SDL_RenderPresent(renderer);
	SDL_DestroyTexture(texture);
}

void Enemy_move_horizontal(Enemy *self, int nb_step, Direction direction, SDL_Renderer *renderer)
{
	for (int i=0;i < nb_step;i++) {
		SDL_RenderClear(renderer);
		if (direction == RIGHT) self->pos.x = self->pos.x + 10;
		if (direction == LEFT) self->pos.x = self->pos.x - 10;
		Enemy_display(self, renderer);
		SDL_RenderPresent(renderer);
		SDL_Delay(100);
	}
}
