#include <stdio.h>
#include <SDL2/SDL.h>

#include "ennemy.h"

int main(int argc, char *argv[]) {
	SDL_Window *window;
	SDL_Renderer *renderer;
	SDL_Event event;
	int quit=0;
	
	if (SDL_VideoInit(NULL) < 0) {
		SDL_LogError(
			SDL_LOG_CATEGORY_APPLICATION,
			"Couldn't initialize SDL video: %s\n",
      SDL_GetError());
			exit(1);
    }

	window = SDL_CreateWindow("Fenetre",
		SDL_WINDOWPOS_UNDEFINED,
		SDL_WINDOWPOS_UNDEFINED,
		640, 480,
		SDL_WINDOW_SHOWN);

	renderer = SDL_CreateRenderer(window, -1, SDL_RENDERER_ACCELERATED);
    
	SDL_SetRenderDrawColor(renderer, 180, 180, 180, 255);
	SDL_RenderClear(renderer);

	Ennemy *ennemy = new_enemy();
	Ennemy_display(ennemy, renderer);
	
	//~ SDL_RenderPresent(renderer);

	while ( !quit ) {
		if ( SDL_PollEvent(&event) ) {
			switch (event.type) {
				case SDL_QUIT:
					quit=1;
					break;
			}//end switch event.type
		}//end if PollEvent
	}//end while quit
	
	SDL_DestroyRenderer(renderer);
	SDL_DestroyWindow(window);

	SDL_Quit();

	exit(0);
}//end main
