#include "scene.h"

Scene *new_scene(SDL_Window *window) {
	Scene *this;
	this = (Scene*) malloc(sizeof(Scene));
	
	this->map = new_map();
	this->hero = new_hero();
	this->ennemy = new_ennemy();
	this->renderer = SDL_CreateRenderer(window, -1, SDL_RENDERER_ACCELERATED);
	return this;
}

int Scene_load_scene(Scene *this,
			char fileMap[SIZE_FILE], char fileBMP[SIZE_FILE]) {
	Map_load_map(this->map, fileMap, fileBMP);
	
	/* On place notre personnage */
	this->hero->pos.x = 64;
	this->hero->pos.y = 192;
	
	/* On affiche la carte et le personnage */
	display_map_sdl(this->map, this->renderer);
	display_hero_sdl(this->hero, this->renderer, 0, 0, W, POS0);
	
	display_ennemy_sdl(this->ennemy, this->renderer, 256, 256);

//	SDL_RenderPresent(this->renderer);
}

void Scene_move_entity(Scene *this, Direction direction) {
		int stepX, stepY;
		int new_x, new_y;
		
		switch (direction) {
			case W:
				stepX = -SIZE_BMP_HERO/4;
				stepY = 0;
				new_x = this->hero->pos.x - SIZE_BMP_MAP;
				new_y = this->hero->pos.y;
				break;
			case N:
				stepX = 0;
				stepY = -SIZE_BMP_HERO/4;
				new_x = this->hero->pos.x ;
				new_y = this->hero->pos.y - SIZE_BMP_MAP;
				break;
			case E:
				stepX = SIZE_BMP_HERO/4;
				stepY = 0;
				new_x = this->hero->pos.x + SIZE_BMP_MAP;
				new_y = this->hero->pos.y;
				break;
			case S:
				stepX = 0;
				stepY = SIZE_BMP_HERO/4;
				new_x = this->hero->pos.x ;
				new_y = this->hero->pos.y + SIZE_BMP_MAP;
				break;
		}

	// Verify if future position is accessible
	int can_move = Map_access_ground(this->map, new_x, new_y);

	if ( can_move == 1 ) {
		display_map_sdl(this->map, this->renderer);
		display_hero_sdl(this->hero, this->renderer, stepX, stepY, direction, POS1);
		SDL_Delay(TIME);
		display_map_sdl(this->map, this->renderer);
		display_hero_sdl(this->hero, this->renderer, stepX, stepY, direction, POS0);
		display_map_sdl(this->map, this->renderer);
		display_hero_sdl(this->hero, this->renderer, stepX, stepY, direction, POS1);
		SDL_Delay(TIME);
		display_map_sdl(this->map, this->renderer);
		display_hero_sdl(this->hero, this->renderer, stepX, stepY, direction, POS0);
	}//end if can_move
}//end Scene_move_entity
