#/usr/bin/env Python3

'''
MàJ :
Axel : 19/08/2019
Alexandre : 01/08/2019
Necessary package : python3-dialog, python3-pil
'''
from tkinter import *
from tkinter import filedialog
from PIL import Image, ImageTk

#Taille par defaut de la map
WIDTH_WINDOW=640
HEIGHT_WINDOW=512
SIZE_BMP=64

'''
appel de la classe:
gui()
'''

class gui:

 #       global map_name
#        global map_memory
        map_memory = ""#Memoire de la carte, boucle while actif seulement sur une ligne
        nb_row = int(HEIGHT_WINDOW/SIZE_BMP) #Ligne de la map
        nb_col = int(WIDTH_WINDOW/SIZE_BMP) #Colonnes de la map
        symb = 'a'
        hold_click = False #Change le terrain selon le deplacement de la souris
        
	
        def __init__(self):
                self.window = Tk()

                #Barre Menu
                self.menubar = Menu(self.window)
                self.window.config(menu=self.menubar)
                self.menuFile = Menu(self.menubar, tearoff=0)
                self.menubar.add_cascade(label="Fichier", menu=self.menuFile)
                self.menuFile.add_command(label="Ouvrir", command=self.open_map)
                self.menuFile.add_command(label="Enregistrer sous", command=self.save_map_as)
                self.menuFile.add_command(label="Quitter", command=self.window.destroy)

                # Dictionnaire associant une lettre
                # a une image d'un terrain

                self.conv = dict()
                self.texture_map = Canvas(self.window, width=3*SIZE_BMP, height=6*SIZE_BMP)

                def create_texture (alpha, name):
                        self.conv[alpha]=name
                        img = Image.open(self.conv.get(alpha))
                        img_map = ImageTk.PhotoImage(img)
                        return img_map

                self.image_map1 = create_texture('a',"terrain1.bmp")
                self.select_image = self.image_map1 #Image im1 (terrain) selectionne par défaut

                self.image_map2 = create_texture('b',"arbre1.bmp")
                self.image_map3 = create_texture('c',"arbre2.bmp")
                self.image_map4 = create_texture('d',"fleur1.bmp")
                self.image_map5 = create_texture('e',"pontH.bmp")
                self.image_map6 = create_texture('f',"pontV.bmp")
                
                self.image_map7 = create_texture('g',"eauC.bmp")
                self.image_map8 = create_texture('h',"eauH.bmp")
                self.image_map9 = create_texture('i',"eauV.bmp")
                self.image_map10 = create_texture('j',"eauNE.bmp")
                self.image_map11 = create_texture('k',"eauSE.bmp")
                self.image_map12 = create_texture('l',"eauNW.bmp")
                
                self.image_map13 = create_texture('m',"eauSW.bmp")
                self.image_map14 = create_texture('n',"eauNEinv.bmp")
                self.image_map15 = create_texture('o',"eauSEinv.bmp")
                self.image_map16 = create_texture('p',"eauNWinv.bmp")
                self.image_map17 = create_texture('q',"eauSWinv.bmp")
                self.image_map18 = create_texture('r',"void.bmp")                

                self.texture_map.create_image(0, 0, image=self.image_map1, anchor=NW)
                self.texture_map.create_image(0, SIZE_BMP, image=self.image_map2, anchor=NW)
                self.texture_map.create_image(0, 2*SIZE_BMP, image=self.image_map3, anchor=NW)
                self.texture_map.create_image(0, 3*SIZE_BMP, image=self.image_map4, anchor=NW)
                self.texture_map.create_image(0, 4*SIZE_BMP, image=self.image_map5, anchor=NW)
                self.texture_map.create_image(0, 5*SIZE_BMP, image=self.image_map6, anchor=NW)

                self.texture_map.create_image(SIZE_BMP, 0, image=self.image_map7, anchor=NW)
                self.texture_map.create_image(SIZE_BMP, SIZE_BMP, image=self.image_map8, anchor=NW)
                self.texture_map.create_image(SIZE_BMP, 2*SIZE_BMP, image=self.image_map9, anchor=NW)
                self.texture_map.create_image(SIZE_BMP, 3*SIZE_BMP, image=self.image_map10, anchor=NW)
                self.texture_map.create_image(SIZE_BMP, 4*SIZE_BMP, image=self.image_map11, anchor=NW)
                self.texture_map.create_image(SIZE_BMP, 5*SIZE_BMP, image=self.image_map12, anchor=NW)         

                self.texture_map.create_image(2*SIZE_BMP, 0, image=self.image_map13, anchor=NW)
                self.texture_map.create_image(2*SIZE_BMP, SIZE_BMP, image=self.image_map14, anchor=NW)
                self.texture_map.create_image(2*SIZE_BMP, 2*SIZE_BMP, image=self.image_map15, anchor=NW)
                self.texture_map.create_image(2*SIZE_BMP, 3*SIZE_BMP, image=self.image_map16, anchor=NW)
                self.texture_map.create_image(2*SIZE_BMP, 4*SIZE_BMP, image=self.image_map17, anchor=NW)
                self.texture_map.create_image(2*SIZE_BMP, 5*SIZE_BMP, image=self.image_map18, anchor=NW)

                self.texture_map.config(bg="grey")
                self.texture_map.bind("<Button-1>", self.manage_event)
                self.texture_map.pack(side=LEFT)

                #Background map
                self.game_map = Canvas(self.window, width=WIDTH_WINDOW, height=HEIGHT_WINDOW)
                self.game_map.config(bd=1, bg="white")

                #Quadrillage map
                for column in range(0, WIDTH_WINDOW-1, SIZE_BMP):
                        #Creer une ligne vertical pour le quadrillage
                        self.game_map.create_line(column, 0, column, HEIGHT_WINDOW, dash=1)

                for row in range(0, HEIGHT_WINDOW-1, SIZE_BMP):
                        #Ligne horizontal
                        self.game_map.create_line(0, row, WIDTH_WINDOW, row, dash=1)

                #self.menubar.pack()
                self.game_map.pack() #Affiche la Background et le quadrillage

                #________________________________________________________________________
                #               SIGNAL CONNECT
                #________________________________________________________________________
                #Insere la texture selectionne sur le quadrillage lorsque que
                #le clique gauche est appuye
                self.game_map.bind("<Button-1>", self.event_set_texture)

                #N'insere plus si le clique gauche est relache
                self.game_map.bind("<ButtonRelease-1>", self.event_release_button)

                #Permet d'inserer la texture sur plusieur cadre si on bouge la souris
                self.game_map.bind("<Motion>", self.event_set_mouse_texture)
                self.textInfo = StringVar()
                self.textInfo.set("Aucune texture sélectionnée")
                self.labelInfo = Label(textvariable=self.textInfo)
                self.labelInfo.pack()
		
                #Tableau map
                ligne = 0
                self.tab_x = []
                while ligne < self.nb_row:
                        tab_y = []
                        colonne=0

                        while colonne < self.nb_col:
                                tab_y.append('0')
                                colonne+=1
                #                self.game_map.create_image(colonne*SIZE_BMP, ligne*SIZE_BMP, image=self.image_map18, anchor=NW)
                        self.tab_x.append(tab_y)
                        ligne+=1
                ###print(self.tab_x)
                
                self.window.mainloop()

#__________________________________________________________________________________________________
#                                           FUNCTION MEMBER
#__________________________________________________________________________________________________

        def open_map(self):
                self.map_memory = 0
                tab_map_mem = list()
                
 #               self.open_filename = "map.txt"
                self.open_filename = filedialog.askopenfilename(title="Sélection d'un fichier")
                ligne = 0
                
                read_file = open(self.open_filename,"r")
           #     read_map = read_file.read()
         #       self.map_memory = read_file.read()
                row=0
                col=0
                for line in read_file:
                        print("ligne: " + line)
                        for char in line:
                                if char=='a':
                                        print("a\n")
                                        self.select_image = self.image_map1
                                        self.game_map.create_image(col*SIZE_BMP, row*SIZE_BMP, image=self.select_image, anchor=NW)
                                elif char=='b':
                                        print("b\n")
                                        self.select_image = self.image_map2
                                        self.game_map.create_image(col*SIZE_BMP, row*SIZE_BMP, image=self.select_image, anchor=NW)
                                elif char=='c':
                                        print("b\n")
                                        self.select_image = self.image_map3
                                        self.game_map.create_image(col*SIZE_BMP, row*SIZE_BMP, image=self.select_image, anchor=NW)

                                elif char=='r':
                                        print("r\n")
                                        self.select_image = self.image_map18
                                        self.game_map.create_image(col*SIZE_BMP, row*SIZE_BMP, image=self.select_image, anchor=NW)
                                else:
                                        print("Defaut\n")
                                col+=1
                        col=0
                        row+=1
                

                #Boucle qui lit le fichier ASCII pour en tirer un tableau pour la map
                #tab_map_mem = map_memory
                

        def save_map_as(self):
                self.filename = filedialog.asksaveasfilename(title="Enregistrer le fichier")
                save_map = open(self.filename, "w+")
                save_map.write(self.map_memory)
                save_map.close()
                print("Sauvegarde de la map\n"+self.filename)
                
        def display_console_map(self):
   #             global map_memory
   #             map_memory = "" #Memoire de la carte, boucle while actif seulement sur une ligne
                self.map_memory = ""
                ###print("\n")
                ligne=0
                
                while ligne < self.nb_row:

                        tab_map = str(self.tab_x[ligne])
                        ###print(str_tab)
                        
                        tab_map_step1 = tab_map.strip('[]') #Enleve les "[]" du tableau
                        ###print(str_tab_1)

                        tab_map_step2 = tab_map_step1.replace("', '","") #Remplace la suite ',(espace)' par du vide ('')
                        ###print(str_tab_2)

                        tab_map_step3 = tab_map_step2.strip("''") #Enleve les ''
                        ###print(tab_map_step3)

                        tab_map_step4 = tab_map_step3 + '\n'
                        ###print(tab_map_step4)

                        self.map_memory = self.map_memory + tab_map_step4 #Incrementation dans la var la ligne traité de la map
                        ###print(map_memory)
                        
                        ligne+=1
                 #x= ' '.join(str(y) for y in self.tab_x)
                 ###print(x)
					
        def manage_event(self, event):
                column = int(event.x/SIZE_BMP)
                row = int(event.y/SIZE_BMP)
                print("Colonne:", column)
                print("Ligne", row)

                def slct_texture(img_map, symb):
                        self.select_image = img_map
                        self.symb = symb
                        print(self.symb,symb)
                        self.textInfo.set("Sélection texture "+self.conv.get(symb).replace('.bmp',''))
                
                if row == 0 and column == 0:
                        slct_texture(self.image_map1,'a')
                        
                elif row == 1 and column == 0:
                        slct_texture(self.image_map2,'b')
                        
                elif row == 2 and column == 0:
                        slct_texture(self.image_map3,'c')
                        
                elif row == 3 and column == 0:
                        slct_texture(self.image_map4,'d')
                        
                elif row == 4 and column == 0:
                        slct_texture(self.image_map5,'e')
                        
                elif row == 5 and column == 0:
                        slct_texture(self.image_map6,'f')
                        

                elif row == 0 and column == 1:
                        slct_texture(self.image_map7,'g')
                        
                elif row == 1 and column == 1:
                        slct_texture(self.image_map8,'h')
                        
                elif row == 2 and column == 1:
                        slct_texture(self.image_map9,'i')

                elif row == 3 and column == 1:
                        slct_texture(self.image_map10,'j')

                elif row == 4 and column == 1:
                        slct_texture(self.image_map11,'k')

                elif row == 5 and column == 1:
                        slct_texture(self.image_map12,'l')
                        

                elif row == 0 and column == 2:
                        slct_texture(self.image_map13,'m')

                elif row == 1 and column == 2:
                        slct_texture(self.image_map14,'n')

                elif row == 2 and column == 2:
                        slct_texture(self.image_map15,'o')

                elif row == 3 and column == 2:
                        slct_texture(self.image_map16,'p')

                elif row == 4 and column == 2:
                        slct_texture(self.image_map17,'q')

                elif row == 5 and column == 2:
                        slct_texture(self.image_map18,'r')
                        
                        
	
        def event_set_texture(self, event):
                self.hold_click = True
                column = int(event.x/SIZE_BMP)
                row = int(event.y/SIZE_BMP)
                #print("Colonne:", column)
                #print("Ligne", row)
                X=SIZE_BMP*column
                Y=SIZE_BMP*row
                self.game_map.create_image(X, Y, image=self.select_image, anchor=NW)
                self.tab_x[row][column] = self.symb
                self.display_console_map()
                ###print(self.tab_x)
                #x= ' '.join(str(y) for y in self.tab_x)
                ###print(x)

        def event_release_button(self, event):
                self.hold_click = False

        def event_set_mouse_texture(self, event):
                if self.hold_click == True:
                        column = int(event.x/SIZE_BMP)
                        row = int(event.y/SIZE_BMP)
                        #print("Colonne:", column)
                        #print("Ligne", row)
                        X=SIZE_BMP*column
                        Y=SIZE_BMP*row
                        self.tab_x[row][column] = self.symb
                        self.display_console_map()
                        self.game_map.create_image(X, Y, image=self.select_image, anchor=NW)

gui()
