#include <SDL2/SDL.h>
#include "hero.h"
#include "scene.h"

int main() {
	SDL_Window *window;
	SDL_Event event;
	int quit=0;
	
	

	if (SDL_VideoInit(NULL) < 0) {
		SDL_LogError(SDL_LOG_CATEGORY_APPLICATION, "Couldn't initialize SDL video: %s\n",
                SDL_GetError());
		exit(1);
	}
	
	window = SDL_CreateWindow("Fenetre",
			0, 0,
	    640, 576, SDL_WINDOW_SHOWN);
	
	/* On cree la scene */
	printf("Creation de la scene\n");
	Scene *scene = new_scene(window);
	printf("Chargement de la scene : map\n");
	Scene_load_scene(scene, "map/map2.txt", "images/image_tuile64x64.bmp");
			
	while ( !quit ) {
		if ( SDL_PollEvent(&event) ) {
			switch (event.type) {
				case SDL_QUIT:
					quit=1;
					break;
				case SDL_KEYUP:
					switch (event.key.keysym.sym) {
						case SDLK_LEFT:
							Scene_move_entity(scene, W);
							break;
						case SDLK_RIGHT:
							Scene_move_entity(scene, E);
							break;
						case SDLK_DOWN:
							Scene_move_entity(scene, S);
							break;
						case SDLK_UP:
							Scene_move_entity(scene, N);
							break;
					}//end switch event.key.keysym.sym
					break;
			}//end switch event.type
		}//end if PollEvent
	}//end while quit
	
	SDL_DestroyWindow(window);
	SDL_Quit();
	return 0;
}
