#include "scene.h"

Scene *new_scene(SDL_Window *window) {
	Scene *this;
	this = (Scene*) malloc(sizeof(Scene));
	
	this->map = new_map();
	this->hero = new_hero();
	this->renderer = SDL_CreateRenderer(window, -1, SDL_RENDERER_ACCELERATED);

	return this;
}

int Scene_load_scene(Scene *this,
			char fileMap[SIZE_FILE], char fileBMP[SIZE_FILE]) {
	Map_load_map(this->map, fileMap, fileBMP);
	
	/* On place notre personnage */
	this->hero->pos.x = 64;
	this->hero->pos.y = 128;
	
	/* On affiche la carte et le personnage */
	display_map_sdl(this->map, this->renderer);
	display_hero_sdl(this->hero, this->renderer, 0, 0, W, POS0);

//	SDL_RenderPresent(this->renderer);
}

void Scene_move_entity(Scene *this, Direction direction) {
	int stepX, stepY;
	
	switch (direction) {
		case W:
			stepX = -SIZE_BMP_HERO/4;
			stepY = 0;
			break;
		case N:
			stepX = 0;
			stepY = -SIZE_BMP_HERO/4;
			break;
		case E:
			stepX = SIZE_BMP_HERO/4;
			stepY = 0;
			break;
		case S:
			stepX = 0;
			stepY = SIZE_BMP_HERO/4;
			break;
	}
	
	display_map_sdl(this->map, this->renderer);
	display_hero_sdl(this->hero, this->renderer, stepX, stepY, direction, POS1);
	SDL_Delay(TIME);
	display_map_sdl(this->map, this->renderer);
	display_hero_sdl(this->hero, this->renderer, stepX, stepY, direction, POS0);
	display_map_sdl(this->map, this->renderer);
	display_hero_sdl(this->hero, this->renderer, stepX, stepY, direction, POS1);
	SDL_Delay(TIME);
	display_map_sdl(this->map, this->renderer);
	display_hero_sdl(this->hero, this->renderer, stepX, stepY, direction, POS0);
}
