from tkinter import *
from PIL import Image, ImageTk

WIDTH_WINDOW=640
HEIGHT_WINDOW=480

class gui:
	hold_click = False
	nb_col = int(WIDTH_WINDOW/40)
	nb_row = int(HEIGHT_WINDOW/40)
	a=[]
	symb = 'a'
	
	def __init__(self):
		self.window = Tk()
		self.im1 = Image.open("terrain.bmp")
		self.im2 = Image.open("eau.bmp")
		self.image_map1 = ImageTk.PhotoImage(self.im1)
		self.select_image = self.image_map1
		self.image_map2 = ImageTk.PhotoImage(self.im2)
		self.texture_map = Canvas(self.window, width=40, height=120)
		self.texture_map.create_image(0, 0, image=self.image_map1, anchor=NW)
		self.texture_map.create_image(0, 40, image=self.image_map2, anchor=NW)
		self.texture_map.config(bg="grey")
		self.texture_map.bind("<Button-1>", self.manage_event)
		self.texture_map.pack(side=LEFT)

		self.game_map = Canvas(self.window, width=WIDTH_WINDOW, height=HEIGHT_WINDOW)
		self.game_map.config(bd=1, bg="white")
		for column in range(0, WIDTH_WINDOW-1, 40):
			self.game_map.create_line(column, 0, column, HEIGHT_WINDOW, dash=1)

		for row in range(0, HEIGHT_WINDOW-1, 40):
			self.game_map.create_line(0, row, WIDTH_WINDOW, row, dash=1)
		self.game_map.pack()
		self.game_map.bind("<Button-1>", self.event_set_texture)
		self.game_map.bind("<ButtonRelease-1>", self.event_release_button)
		self.game_map.bind("<Motion>", self.event_set_mouse_texture)

		self.labelInfo = Label(text="Aucune texture sélectionnée")
		self.labelInfo.pack()
		
		r=0
		while r < self.nb_row:
			_c = []
			c=0
			while c < self.nb_col:
				_c.append('a')
				c=c+1
			self.a.append(_c)
			r=r+1
		print(self.a)

		self.window.mainloop()
		
	def manage_event(self, event):
		column = int(event.x/40)
		row = int(event.y/40)
		print("Colonne:", column)
		print("Ligne", row)
		if row == 0:
			self.select_image = self.image_map1
			self.symb = 'a'
		if row == 1:
			self.select_image = self.image_map2
			self.symb = 'b'
	
	def event_set_texture(self, event):
		self.hold_click = True
		column = int(event.x/40)
		row = int(event.y/40)
#		print("Colonne:", column)
#		print("Ligne", row)
		X=40*column
		Y=40*row
		self.game_map.create_image(X, Y, image=self.select_image, anchor=NW)
		self.a[row][column] = self.symb
#		print(self.a)

	def event_release_button(self, event):
		self.hold_click = False
		
	def event_set_mouse_texture(self, event):
		if self.hold_click == True:
			column = int(event.x/40)
			row = int(event.y/40)
#			print("Colonne:", column)
#			print("Ligne", row)
			X=40*column
			Y=40*row
			self.game_map.create_image(X, Y, image=self.select_image, anchor=NW)
