#include "hero.h"

Hero *new_hero() {
	Hero *this;
	this = (Hero*) malloc(sizeof(Hero));
	this->mana = 100;
	this->health = 100;
	this->heroSprite.x = 0;
	this->heroSprite.y = 0;
	this->heroSprite.w = SIZE_BMP_HERO;
	this->heroSprite.h = SIZE_BMP_HERO;
	this->pos.x = 0;
	this->pos.y = 0;
	this->pos.w = SIZE_BMP_HERO;
	this->pos.h = SIZE_BMP_HERO;
	this->surface = SDL_LoadBMP("personnage40x40.bmp");
	if (this->surface) {
		printf("Chargement de l'image dans le constructeur\n");
	} else {
		printf("Erreur dans le chargement de l'image : %s\n", SDL_GetError());
	}
	SDL_SetColorKey(this->surface, SDL_TRUE, SDL_MapRGB(this->surface->format, 255, 255, 255));
	return this;
}

SDL_Rect get_pos(Hero *hero) {
	return hero->pos;
}

void display_hero_sdl(Hero *this, SDL_Renderer *renderer, 
				int stepX, int stepY, Direction direction, FramePos framepos
				) {
	SDL_Texture *texture;
	
	if (this->surface) {
		printf("Image personnage ok\n");
		texture=SDL_CreateTextureFromSurface(renderer, this->surface);
	} else {
		printf("Probleme image perso\n");
	}
	
		this->pos.x = this->pos.x + stepX;
		this->pos.y = this->pos.y + stepY;
	
		switch (framepos) {
			case POS0:
				this->heroSprite.x = 0;
				break;
			case POS1:
				this->heroSprite.x = SIZE_BMP_HERO;
				break;
			default: break;
		}
		
		switch (direction) {
			case E:
				this->heroSprite.y = 0;
				break;
			case N:
				this->heroSprite.y = SIZE_BMP_HERO;
				break;
			case W:
				this->heroSprite.y = 2*SIZE_BMP_HERO;
				break;
			case S:
				this->heroSprite.y = 3*SIZE_BMP_HERO;
				break;
			default: break;
		}
		
		SDL_RenderCopy(renderer, texture, &this->heroSprite, &this->pos);

		SDL_RenderPresent(renderer);
	SDL_DestroyTexture(texture);
}

