#include <SDL2/SDL.h>
#include "map.h"

int main() {
	SDL_Window *window;
	SDL_Event event;
	SDL_Renderer *renderer;
	int quit=0;
	
	SDL_Rect perso;
	perso.x = 32;
	perso.y = 32;
	perso.w = 32;
	perso.h = 32;

	if (SDL_VideoInit(NULL) < 0) {
		SDL_LogError(SDL_LOG_CATEGORY_APPLICATION, "Couldn't initialize SDL video: %s\n",
                SDL_GetError());
        exit(1);
	}
	
	window = SDL_CreateWindow("Fenetre", SDL_WINDOWPOS_UNDEFINED, SDL_WINDOWPOS_UNDEFINED,
	                          640, 480, SDL_WINDOW_SHOWN);
	
	renderer = SDL_CreateRenderer(window, -1, SDL_RENDERER_ACCELERATED);

Map *map;
map = new_map("map.txt");
Map_display_array_map(map);
	
	display_map_sdl(map, renderer);
			SDL_RenderFillRect( renderer, &perso );
			SDL_RenderPresent(renderer);
			
	/*
		for (int i=0; i<640; i+=4) {
			perso.x=i;
			SDL_Delay(40);
			display_map_sdl(map, renderer);
			SDL_RenderFillRect( renderer, &perso );
			SDL_RenderPresent(renderer);
		}
*/
	
	/*
	display_map("map.txt");
	*/
	
	while ( !quit ) {
		if ( SDL_PollEvent(&event) ) {
			switch (event.type) {
				case SDL_QUIT:
					quit=1;
					break;
				case SDL_KEYDOWN:
					switch (event.key.keysym.sym) {
						case SDLK_LEFT:
							perso.x -=32;
							display_map_sdl(map, renderer);
							SDL_RenderFillRect( renderer, &perso );
							SDL_RenderPresent(renderer);
							break;
						case SDLK_RIGHT:
							printf("Touche droite\n");
							perso.x +=32;
							display_map_sdl(map, renderer);
							SDL_RenderFillRect( renderer, &perso );
							SDL_RenderPresent(renderer);
							break;
						case SDLK_DOWN:
							perso.y +=32;
							display_map_sdl(map, renderer);
							SDL_RenderFillRect( renderer, &perso );
							SDL_RenderPresent(renderer);
							break;
						case SDLK_UP:
							perso.y -=32;
							display_map_sdl(map, renderer);
							SDL_RenderFillRect( renderer, &perso );
							SDL_RenderPresent(renderer);
							break;
					}//end switch event.key.keysym.sym
					break;
			}//end switch event.type
		}//end if PollEvent
	}//end while quit
	
	SDL_DestroyWindow(window);
	SDL_Quit();
	return 0;
}
