#include <stdio.h>
#include <string.h>
#include "map.h"

Map *new_map(char fileMap[100], char fileBMP[100]) {
	Map *this;
	char tile;
	int i=0;
	int j=0;
	
	this = (Map*) malloc (sizeof(Map));
	
	/* On lit le fichier ASCII de la Map
	 * et on met son contenu dans arrayMap[][]
	 */
	FILE *f;
	f = fopen(fileMap, "r");
	while ( (tile=getc(f)) != EOF ) {
		if ( tile != '\n' ) {
			this->arrayMap[i][j] = tile;
			i++;
		} else {
			j++;
			i=0;
		}
	}
	fclose(f);
	
	printf("Chargement de l'image : %s\n", fileBMP);
	this->surface = SDL_LoadBMP(fileBMP);

	if (this->surface) {
		printf("Chargement de l'image de la map dans le constructeur new_map()\n");
	} else {
		printf("Erreur chargement de la map : %s\n", SDL_GetError());
	}
	
	return this;
}//end constructor Map

void Map_display_array_map(Map *this) {
	int l=0;
	int c=0;
	while (l < NB_DIV_Y) {
		while (c < NB_DIV_X) {
			printf("%c", this->arrayMap[c][l]);
			c++;
		}
		printf("\n");
		c=0;
		l++;
	}
}//end Map_display_array_map

void display_map(char name_map[20]) {
	char tile;

	printf("Affichage de la carte en mode console\n");
	FILE *file_map;
	file_map = fopen(name_map, "r");
	while ( (tile=getc(file_map)) != EOF ) {
		printf("%c", tile);
	} 

	file_map = fopen(name_map, "r");
	while ( (tile=getc(file_map)) != EOF ) {
		if ( tile!='\n') {
			printf("%i ", tile);
		}  else {
			printf("%i\n", tile);
		}
	}

	fclose(file_map);
}//end display_map

void display_map_sdl(Map *this, SDL_Renderer *renderer) {
	SDL_Texture *texture;
	SDL_Rect source, destination;

	if (this->surface) {
		printf("Creation de la texture\n");
		texture = SDL_CreateTextureFromSurface(renderer, this->surface);
	} else {
		printf("Erreur dans la creation de la surface de la map : %s\n", SDL_GetError());
	}
	source.x=0;
	source.y=0;
	source.h=32;
	source.w=32;
	destination.x=0;
	destination.y=0;
	destination.h=32;
	destination.w=32;
	int c, l;
	c=0;
	l=0;

	if (texture == NULL) {	
		printf("Erreur texture : %s\n", SDL_GetError());
	} else {
		while (c<NB_DIV_X) {
			destination.x = 32*c;
			while (l<NB_DIV_Y) {
				destination.y = 32*l;
				switch (this->arrayMap[c][l]) {
					case 'a':
						source.x=0;
						break;
					case 'b':
						source.x=32;
						break;
					case 'c':
						source.x=64;
						break;
				}
				SDL_RenderCopy(renderer, texture, &source, &destination);
				l++;
			}//end while l
			c++;
			l=0;
		}//end while c
		SDL_DestroyTexture(texture);
	}//end if texture
}//end display_map_sdl
