#include <SDL2/SDL.h>
#include "map.h"
#include "hero.h"

int main() {
	SDL_Window *window;
	SDL_Event event;
	SDL_Renderer *renderer;
	int quit=0;
	
	

	if (SDL_VideoInit(NULL) < 0) {
		SDL_LogError(SDL_LOG_CATEGORY_APPLICATION, "Couldn't initialize SDL video: %s\n",
                SDL_GetError());
        exit(1);
	}
	
	window = SDL_CreateWindow("Fenetre",
			0, 0,
	    640, 480, SDL_WINDOW_SHOWN);
	
	renderer = SDL_CreateRenderer(window, -1, SDL_RENDERER_ACCELERATED);

	/* On cree notre personnage */
	Hero *hero = new_hero();
	hero->pos.x = 192;
	hero->pos.y = 32;
	
	/* On cree la Carte */
	Map *map;
	map = new_map("map.txt", "image_tuile.bmp");

	/* On affiche la carte et le personnage */
	display_map_sdl(map, renderer);
	display_hero_sdl(hero, renderer, 0, 0);

	SDL_RenderPresent(renderer);
			
	while ( !quit ) {
		if ( SDL_PollEvent(&event) ) {
			switch (event.type) {
				case SDL_QUIT:
					quit=1;
					break;
				case SDL_KEYDOWN:
					switch (event.key.keysym.sym) {
						case SDLK_LEFT:
							display_map_sdl(map, renderer);
							display_hero_sdl(hero, renderer, -32, 0);
							SDL_RenderPresent(renderer);
							break;
						case SDLK_RIGHT:
							display_map_sdl(map, renderer);
							display_hero_sdl(hero, renderer, 32, 0);
							SDL_RenderPresent(renderer);
							break;
						case SDLK_DOWN:
							display_map_sdl(map, renderer);
							display_hero_sdl(hero, renderer, 0, 32);
							SDL_RenderPresent(renderer);
							break;
						case SDLK_UP:
							display_map_sdl(map, renderer);
							display_hero_sdl(hero, renderer, 0, -32);
							SDL_RenderPresent(renderer);
							break;
					}//end switch event.key.keysym.sym
					break;
			}//end switch event.type
		}//end if PollEvent
	}//end while quit
	
	SDL_DestroyWindow(window);
	SDL_Quit();
	return 0;
}
