#include <SDL2/SDL.h>
#include "map.h"

int main() {
	SDL_Window *window;
	SDL_Event event;
	SDL_Renderer *renderer;
	int quit=0;

	if (SDL_VideoInit(NULL) < 0) {
		SDL_LogError(SDL_LOG_CATEGORY_APPLICATION, "Couldn't initialize SDL video: %s\n",
                SDL_GetError());
        exit(1);
	}
	
	window = SDL_CreateWindow("Fenetre", SDL_WINDOWPOS_UNDEFINED, SDL_WINDOWPOS_UNDEFINED,
	                          640, 480, SDL_WINDOW_SHOWN);
	
	renderer = SDL_CreateRenderer(window, -1, SDL_RENDERER_ACCELERATED);

Map *map;
map = new_map("map.txt");
Map_display_array_map(map);
	
	
	display_map_sdl(map, renderer);
	SDL_RenderPresent(renderer);
	
	/*
	display_map("map.txt");
	*/
	
	while ( !quit ) {
		if ( SDL_PollEvent(&event) ) {
			switch (event.type) {
				case SDL_QUIT:
					quit=1;
					break;
			}//end switch event.type
		}//end if PollEvent
	}//end while quit
	
	SDL_DestroyWindow(window);
	SDL_Quit();
	return 0;
}
