#/usr/bin/env Python3

from tkinter import *
from PIL import Image, ImageTk

#Taille par defaut de la map
WIDTH_WINDOW=640
HEIGHT_WINDOW=512
SIZE_BMP=64

'''
appel de la classe:
gui()
'''

class gui:

        nb_row = int(HEIGHT_WINDOW/SIZE_BMP) #Ligne de la map
        nb_col = int(WIDTH_WINDOW/SIZE_BMP) #Colonnes de la map
        symb = 'a'
        hold_click = False #Change le terrain selon le deplacement de la souris 
	
        def __init__(self):
                self.window = Tk()
                self.menubar = Menu(self.window)
                self.window.config(menu=self.menubar)
                self.menuFile = Menu(self.menubar, tearoff=0)
                self.menubar.add_cascade(label="Fichier", menu=self.menuFile)
                self.menuFile.add_command(label="Ouvrir", command=self.open_map)
                self.menuFile.add_command(label="Enregistrer sous", command=self.save_map_as)
                self.menuFile.add_command(label="Quitter", command=self.window.destroy)
                
                self.im1 = Image.open("terrain1.bmp") #Lecture d'image
                self.im2 = Image.open("eauV.bmp")
                self.im3 = Image.open("arbre1.bmp")
                self.image_map1 = ImageTk.PhotoImage(self.im1) #Affiche l'image
                self.select_image = self.image_map1 #Image im1 (terrain) selectionne par défaut
                self.image_map2 = ImageTk.PhotoImage(self.im2)
                self.image_map3 = ImageTk.PhotoImage(self.im3)
                self.texture_map = Canvas(self.window, width=SIZE_BMP, height=3*SIZE_BMP)
                self.texture_map.create_image(0, 0, image=self.image_map1, anchor=NW)
                self.texture_map.create_image(0, SIZE_BMP, image=self.image_map2, anchor=NW)
                self.texture_map.create_image(0, 2*SIZE_BMP, image=self.image_map3, anchor=NW)
                self.texture_map.config(bg="grey")
                self.texture_map.bind("<Button-1>", self.manage_event)
                self.texture_map.pack(side=LEFT)

                #Background map
                self.game_map = Canvas(self.window, width=WIDTH_WINDOW, height=HEIGHT_WINDOW)
                self.game_map.config(bd=1, bg="white")

                #Quadrillage map
                for column in range(0, WIDTH_WINDOW-1, SIZE_BMP):
                        #Creer une ligne vertical pour le quadrillage
                        self.game_map.create_line(column, 0, column, HEIGHT_WINDOW, dash=1)

                for row in range(0, HEIGHT_WINDOW-1, SIZE_BMP):
                        #Ligne horizontal
                        self.game_map.create_line(0, row, WIDTH_WINDOW, row, dash=1)
                        
#                self.menubar.pack()
                self.game_map.pack() #Affiche la Background et le quadrillage

                #Insere la texture selectionne sur le quadrillage lorsque que
                #le clique gauche est appuye
                self.game_map.bind("<Button-1>", self.event_set_texture)

                #N'insere plus si le clique gauche est relache
                self.game_map.bind("<ButtonRelease-1>", self.event_release_button)

                #Permet d'inserer la texture sur plusieur cadre si on bouge la souris
                self.game_map.bind("<Motion>", self.event_set_mouse_texture)

                self.labelInfo = Label(text="Aucune texture sélectionnée")
                self.labelInfo.pack()
		
                #Tableau map
                ligne = 0
                self.tab_x = []
                while ligne < self.nb_row:

                        tab_y = []
                        colonne=0

                        while colonne < self.nb_col:

                                tab_y.append('0')
                                colonne+=1
                        self.tab_x.append(tab_y)
                        ligne+=1
 #               print(self.tab_x)
                #x = str(self.tab_x).strip('[]')
                #x = '\n'.join(str(self.tab_x))
#                x= ' '.join(str(y) for y in self.tab_x)
#                print(x)
                

                self.window.mainloop()

        def open_map(self):
                print("Ouverture d'une map\n")

        def save_map_as(self):
                print("Sauvegarde de la map\n")
                
        def display_console_map(self):
                print("\n")
                ligne=0
                while ligne < self.nb_row:
                        print(self.tab_x[ligne])
                        ligne+=1
#                x= ' '.join(str(y) for y in self.tab_x)
#                print(x)
					
        def manage_event(self, event):
                column = int(event.x/SIZE_BMP)
                row = int(event.y/SIZE_BMP)
                print("Colonne:", column)
                print("Ligne", row)
                if row == 0:
                        self.select_image = self.image_map1
                        self.symb = 'a'
                if row == 1:
                        self.select_image = self.image_map2
                        self.symb = 'b'
                if row == 2:
                        self.select_image = self.image_map3
                        self.symb = 'c'
	
        def event_set_texture(self, event):
                self.hold_click = True
                column = int(event.x/SIZE_BMP)
                row = int(event.y/SIZE_BMP)
                #print("Colonne:", column)
                #print("Ligne", row)
                X=SIZE_BMP*column
                Y=SIZE_BMP*row
                self.game_map.create_image(X, Y, image=self.select_image, anchor=NW)
                self.tab_x[row][column] = self.symb
                self.display_console_map()
    #            print(self.tab_x)
    #            x= ' '.join(str(y) for y in self.tab_x)
    #            print(x)

        def event_release_button(self, event):
                self.hold_click = False

        def event_set_mouse_texture(self, event):
                if self.hold_click == True:
                        column = int(event.x/SIZE_BMP)
                        row = int(event.y/SIZE_BMP)
                        #print("Colonne:", column)
                        #print("Ligne", row)
                        X=SIZE_BMP*column
                        Y=SIZE_BMP*row
                        self.tab_x[row][column] = self.symb
                        self.display_console_map()
                        self.game_map.create_image(X, Y, image=self.select_image, anchor=NW)

