using Gtk;
using Sqlite;

using BillingType;

namespace Customer{
	public struct DataCustomer {
			string AccountingCoding;
			string CompanyName;
			string ResponsibleName;
			string TenantAddress;
			string TenantAddressComplement;
			string TenantPostalCode;
			string PhoneNumber;
			
			string RentedPropertyAddress;
			string CadastralPlan;
			string BuildingSurface;
			string FieldSurface;
			
			string RentBeginning;
			string RentEnding;
			string RentReview;
			string RentPeriodicity;
			string AnnualRentPreTax;
			string IndexType;
			string ReferenceQuarter;
			string BaseIndex;
			string QuarterReview;		
			
			string NewIndex;
			string LastIndex;
			string SecurityDepositPreTax;
			string SecurityDepositIncludedTax;
			string ProvisionsForExpenses;
			string ExpensesPaymentReceipt;
			string LastAnnualRentalPreTax;
			string LastAnnualRentalPreTaxAndPreCharges;
			string LastAnnualRentalWithTaxAndPreCharges;
			string LastAnnualRentalPreTaxAndCharges;
			string LastAnnualRentalWithTaxAndCharges;
			string IbanCode;
		}
		
	// classe Customer (Parent)
	public class Customer: Gtk.Window {
		
		protected DataCustomer dataCustomer;
		protected DataCustomer listDataCustomer[50];
		protected int incrementCustomer;
		protected int nbCustomer;
		protected Sqlite.Database db;
		protected string errmsg;
		
		protected string pathDBCustomer;
		
		
		public void display_list_data_customer() {
	//		int size = this.listDataCustomer.length;
			for (int i=0; i<this.nbCustomer;i++) {
				print(" Nom Société: %s\n Nom Responsable: %s\n Périodicité: %s\n Trimestre Révision: %s\n\n",
					this.listDataCustomer[i].CompanyName, this.listDataCustomer[i].ResponsibleName,
					this.listDataCustomer[i].RentPeriodicity, this.listDataCustomer[i].QuarterReview
				);
			}//end for
		}//end display_list_data_customer
		
		/*
		 * This function is called by select_table_customer()
		 * this function is called several times until empty records
		 */
		private int exec_callback_select_table_customer(int n_columns,
				string[] values, string[] column_names) {
			//		print("taille : %d\n", n_columns);

					for (int i = 0; i < n_columns; i++) {
				//		print("incrementCustomer=%d\n", this.incrementCustomer);
				//		print("col : %s\tname : %s\n", column_names[i], values[i]);
						switch (column_names[i]) {
							case "AccountingCoding":
								this.listDataCustomer[this.incrementCustomer].AccountingCoding = values[i];
								break;
							case "CompanyName":
								this.listDataCustomer[this.incrementCustomer].CompanyName = values[i];
								break;
							case "ResponsibleName":
								this.listDataCustomer[this.incrementCustomer].ResponsibleName = values[i];
								break;
							case "TenantAddress":
								this.listDataCustomer[this.incrementCustomer].TenantAddress = values[i];
								break;
							case "TenantAddressComplement":
								this.listDataCustomer[this.incrementCustomer].TenantAddressComplement = values[i];
								break;
							case "TenantPostalCode":
								this.listDataCustomer[this.incrementCustomer].TenantPostalCode = values[i];
								break;
							case "PhoneNumber":
								this.listDataCustomer[this.incrementCustomer].PhoneNumber = values[i];
								break;
							
							case "RentedPropertyAddress":
								this.listDataCustomer[this.incrementCustomer].RentedPropertyAddress = values[i];
								break;
							case "CadastralPlan":
								this.listDataCustomer[this.incrementCustomer].CadastralPlan = values[i];
								break;
							case "BuildingSurface":
								this.listDataCustomer[this.incrementCustomer].BuildingSurface = values[i];
								break;
							case "FieldSurface":
								this.listDataCustomer[this.incrementCustomer].FieldSurface = values[i];
								break;
								
							case "RentBeginning":
								this.listDataCustomer[this.incrementCustomer].RentBeginning = values[i];
								break;
							case "RentEnding":
								this.listDataCustomer[this.incrementCustomer].RentEnding = values[i];
								break;
							case "RentReview":
								this.listDataCustomer[this.incrementCustomer].RentReview = values[i];
								break;
							case "RentPeriodicity":
								switch (values[i]) {
									case "MONTHLY":
										this.listDataCustomer[this.incrementCustomer].RentPeriodicity = "Mensuelle";
										break;
									case "QUARTERLY":
										this.listDataCustomer[this.incrementCustomer].RentPeriodicity = "Trimestrielle";
										break;
									case "BIANNUAL":
										this.listDataCustomer[this.incrementCustomer].RentPeriodicity = "Semestrielle";
										break;
								}//end switch values[i]
								break;
							case "AnnualRentPreTax":
								this.listDataCustomer[this.incrementCustomer].AnnualRentPreTax = values[i];
								break;
							case "IndexType":
								this.listDataCustomer[this.incrementCustomer].IndexType = values[i];
								break;
							case "ReferenceQuarter":
								this.listDataCustomer[this.incrementCustomer].ReferenceQuarter = values[i];
								break;
							case "BaseIndex":
								this.listDataCustomer[this.incrementCustomer].BaseIndex = values[i];
								break;
							case "QuarterReview":
								this.listDataCustomer[this.incrementCustomer].QuarterReview = values[i];
								break;
								
								
							case "NewIndex":
								this.listDataCustomer[this.incrementCustomer].NewIndex = values[i];
								break;
							case "LastIndex":
								this.listDataCustomer[this.incrementCustomer].LastIndex = values[i];
								break;
							case "SecurityDepositPreTax":
								this.listDataCustomer[this.incrementCustomer].SecurityDepositPreTax = values[i];
								break;
							case "SecurityDepositIncludedTax":
								this.listDataCustomer[this.incrementCustomer].SecurityDepositIncludedTax = values[i];
								break;
							case "ProvisionsForExpenses":
								this.listDataCustomer[this.incrementCustomer].ProvisionsForExpenses = values[i];
								break;
							case "ExpensesPaymentReceipt":
								this.listDataCustomer[this.incrementCustomer].ExpensesPaymentReceipt = values[i];
								break;
							case "LastAnnualRentalPreTax":
								this.listDataCustomer[this.incrementCustomer].LastAnnualRentalPreTax = values[i];
								break;
							case "LastAnnualRentalPreTaxAndPreCharges":
								this.listDataCustomer[this.incrementCustomer].LastAnnualRentalPreTaxAndPreCharges = values[i];
								break;
							case "LastAnnualRentalWithTaxAndPreCharges":
								this.listDataCustomer[this.incrementCustomer].LastAnnualRentalWithTaxAndPreCharges = values[i];
								break;
							case "LastAnnualRentalPreTaxAndCharges":
								this.listDataCustomer[this.incrementCustomer].LastAnnualRentalPreTaxAndCharges = values[i];
								break;
							case "LastAnnualRentalWithTaxAndCharges":
								this.listDataCustomer[this.incrementCustomer].LastAnnualRentalWithTaxAndCharges = values[i];
								break;
							case "IbanCode":
								this.listDataCustomer[this.incrementCustomer].IbanCode = values[i];
								break;
										
						}//end switch
					}//end for
					this.incrementCustomer++;
					return 0;
		}//end exec_callback_select_table_customer
		
		public int select_table_customer() {
			int res = Sqlite.Database.open(this.pathDBCustomer, out this.db);
			if (res!=Sqlite.OK) {
				print("Error : %d : %s\n", this.db.errcode(), this.db.errmsg());
				return -1;
			}
			
			this.incrementCustomer = 0;
			string query = "SELECT * FROM Customer ORDER BY CompanyName";
			res = this.db.exec(query, exec_callback_select_table_customer, out this.errmsg);
			if (res!=Sqlite.OK) {
				print("Error : %s\n", this.errmsg);
				return -1;
			}
			this.nbCustomer = this.incrementCustomer;
			return 0;
		}//end select_table_customer

		public int insert_table_customer() {
			int res = Sqlite.Database.open(this.pathDBCustomer, out this.db);
			if ( res != Sqlite.OK ) {
				print("Error : %d : %s\n", this.db.errcode(), this.db.errmsg());
				return -1;
			}
			
			string rPeriodicity = "NULL";
			switch (this.dataCustomer.RentPeriodicity) {
				case "Mensuelle":
					rPeriodicity = "MONTHLY";
					break;
				case "Trimestrielle":
					rPeriodicity = "QUARTERLY";
					break;
				case "Semestrielle":
					rPeriodicity = "BIANNUAL";
					break;
			}//end switch RentPeriodicity
			
			string rReview = "NULL";
			switch (this.dataCustomer.RentReview) {
				case "Janvier":
					rReview = "JANUARY";
					break;
				case "Février":
					rReview = "FEBRUARY";
					break;
				case "Mars":
					rReview = "MARCH";
					break;
				case "Avril":
					rReview = "APRIL";
					break;
				case "Mai":
					rReview = "MAY";
					break;
				case "Juin":
					rReview = "JUNE";
					break;
				case "Juillet":
					rReview = "JULY";
					break;
				case "Août":
					rReview = "AUGUST";
					break;
				case "Septembre":
					rReview = "SEPTEMBER";
					break;
				case "Octobre":
					rReview = "OCTOBER";
					break;
				case "Novembre":
					rReview = "NOVEMBER";
					break;
				case "Décembre":
					rReview = "DECEMBER";
					break;
			}//end switch RentBeginning
			
			var strAccountingCoding = this.dataCustomer.AccountingCoding.replace("'", "''");
			var strCompanyName = this.dataCustomer.CompanyName.replace("'", "''");
			var strResponsibleName = this.dataCustomer.ResponsibleName.replace("'", "''");
			var strTenantAddress = this.dataCustomer.TenantAddress.replace("'", "''");
			var strTenantAddressComplement = this.dataCustomer.TenantAddressComplement.replace("'", "''");
			var strTenantPostalCode = this.dataCustomer.TenantPostalCode.replace("'", "''");
			var strPhoneNumber = this.dataCustomer.PhoneNumber.replace("'", "''");
			
			var strRentedPropertyAddress = this.dataCustomer.RentedPropertyAddress.replace("'", "''");
			var strCadastralPlan = this.dataCustomer.CadastralPlan.replace("'", "''");
			var strBuildingSurface = this.dataCustomer.BuildingSurface.replace("'", "''");
			var strFieldSurface = this.dataCustomer.FieldSurface.replace("'", "''");
			
			var strRentBeginning = this.dataCustomer.RentBeginning.replace("'", "''");
			var strRentEnding = this.dataCustomer.RentEnding.replace("'", "''");
			var strAnnualRentPreTax = this.dataCustomer.AnnualRentPreTax.replace("'", "''");
			var strIndexType = this.dataCustomer.IndexType.replace("'", "''");
			var strReferenceQuarter = this.dataCustomer.ReferenceQuarter.replace("'", "''");
			var strBaseIndex = this.dataCustomer.BaseIndex.replace("'", "''");

			var strNewIndex = this.dataCustomer.NewIndex.replace("'", "''");
			var strLastIndex = this.dataCustomer.LastIndex.replace("'", "''");
			var strSecurityDepositPreTax = this.dataCustomer.SecurityDepositPreTax.replace("'", "''");
			var strSecurityDepositIncludedTax = this.dataCustomer.SecurityDepositIncludedTax.replace("'", "''");
			var strProvisionsForExpenses = this.dataCustomer.ProvisionsForExpenses.replace("'", "''");
			var strExpensesPaymentReceipt = this.dataCustomer.ExpensesPaymentReceipt.replace("'", "''");
			var strLastAnnualRentalPreTax = this.dataCustomer.LastAnnualRentalPreTax.replace("'", "''");
			var strLastAnnualRentalPreTaxAndPreCharges = this.dataCustomer.LastAnnualRentalPreTaxAndPreCharges.replace("'", "''");
			var strLastAnnualRentalWithTaxAndPreCharges = this.dataCustomer.LastAnnualRentalWithTaxAndPreCharges.replace("'", "''");
			var strLastAnnualRentalPreTaxAndCharges = this.dataCustomer.LastAnnualRentalPreTaxAndCharges.replace("'", "''");
			var strLastAnnualRentalWithTaxAndCharges = this.dataCustomer.LastAnnualRentalWithTaxAndCharges.replace("'", "''");
			var strIbanCode = this.dataCustomer.IbanCode.replace("'", "''");
			
			string query = """
			INSERT INTO Customer (
					AccountingCoding, CompanyName, 
					ResponsibleName, TenantAddress, 
					TenantAddressComplement, TenantPostalCode,
					PhoneNumber, 
					
					RentedPropertyAddress, CadastralPlan,
					BuildingSurface, FieldSurface,
					
					RentBeginning, RentEnding,
					RentReview, RentPeriodicity,
					AnnualRentPreTax, IndexType,
					ReferenceQuarter, BaseIndex,
					QuarterReview,
					
					NewIndex, LastIndex,
					SecurityDepositPreTax, SecurityDepositIncludedTax,
					ProvisionsForExpenses, ExpensesPaymentReceipt,
					LastAnnualRentalPreTax, LastAnnualRentalPreTaxAndPreCharges,
					LastAnnualRentalWithTaxAndPreCharges, LastAnnualRentalPreTaxAndCharges,
					LastAnnualRentalWithTaxAndCharges, IbanCode
					) VALUES (
				"""+
				"'"+strAccountingCoding+"',"+
				"'"+strCompanyName+"',"+
				"'"+strResponsibleName+"',"+
				"'"+strTenantAddress+"',"+
				"'"+strTenantAddressComplement+"',"+
				"'"+strTenantPostalCode+"',"+
				"'"+strPhoneNumber+"',"+
				
				"'"+strRentedPropertyAddress+"',"+
				"'"+strCadastralPlan+"',"+
				"'"+strBuildingSurface+"',"+
				"'"+strFieldSurface+"',"+
				
				"'"+strRentBeginning+"' ,"+
				"'"+strRentEnding+"' ,"+
				"'"+rReview+"',"+
				"'"+rPeriodicity+"',"+
				"'"+strAnnualRentPreTax+"' ,"+
				"'"+strIndexType+"' ,"+
				"'"+strReferenceQuarter+"' ,"+
				"'"+strBaseIndex+"' ,"+
				"'"+this.dataCustomer.QuarterReview+"' ,"+
				
				"'"+strNewIndex+"' ,"+
				"'"+strLastIndex+"' ,"+
				"'"+strSecurityDepositPreTax+"' ,"+
				"'"+strSecurityDepositIncludedTax+"' ,"+
				"'"+strProvisionsForExpenses+"' ,"+
				"'"+strExpensesPaymentReceipt+"' ,"+
				"'"+strLastAnnualRentalPreTax+"' ,"+
				"'"+strLastAnnualRentalPreTaxAndPreCharges+"' ,"+
				"'"+strLastAnnualRentalWithTaxAndPreCharges+"' ,"+
				"'"+strLastAnnualRentalPreTaxAndCharges+"' ,"+
				"'"+strLastAnnualRentalWithTaxAndCharges+"' ,"+
				"'"+strIbanCode+"'"+
				");";
				res = this.db.exec(query, null, out this.errmsg);
				if (res!=Sqlite.OK) {
					print("Error : %s\n", this.errmsg);
					return -1;
				}
//			print("Requete :%s OK\n", query);
			return 0;
		}

		public int delete_table_customer(string companyName) {
			var strCompanyName = companyName.replace("'", "''");
			var query = "DELETE FROM Customer WHERE CompanyName='"+strCompanyName+"';";
			print("Requete %s\n", query);
			int result = this.db.exec(query, null, out this.errmsg);
			if ( result != Sqlite.OK) {
				print("Erreur requete : %s\n", this.errmsg);
				return -1;
			}		
			return 0;
		}
		
		public int create_table_customer() {
			var query = """
				CREATE TABLE Customer (
				AccountingCoding TEXT, CompanyName TEXT, 
				ResponsibleName TEXT, TenantAddress TEXT,
				TenantAddressComplement TEXT, TenantPostalCode TEXT,
				PhoneNumber TEXT,
				
				RentedPropertyAddress TEXT, CadastralPlan TEXT,
				BuildingSurface REAL, FieldSurface REAL,
				
				RentBeginning TEXT, RentEnding TEXT,
				RentReview TEXT,RentPeriodicity TEXT,
				AnnualRentPreTax REAL, IndexType TEXT,
				ReferenceQuarter TEXT, BaseIndex REAL,
				QuarterReview TEXT,
				
				NewIndex READ, LastIndex REAL,
				SecurityDepositPreTax REAL, SecurityDepositIncludedTax REAL,
				ProvisionsForExpenses REAL, ExpensesPaymentReceipt REAL,
				LastAnnualRentalPreTax REAL, LastAnnualRentalPreTaxAndPreCharges REAL,
				LastAnnualRentalWithTaxAndPreCharges REAL, LastAnnualRentalPreTaxAndCharges REAL,
				LastAnnualRentalWithTaxAndCharges REAL, IbanCode REAL
				);
			""";
			int result = this.db.exec(query, null, out this.errmsg);
			if ( result != Sqlite.OK) {
				print("Erreur requete : %s\n", this.errmsg);
				return -1;
			}
			return 0;
		}
		
		public int create_database() {
			int result = Sqlite.Database.open(this.pathDBCustomer, out this.db);
			if ( result != Sqlite.OK ) {
				print("Probleme creation de la base : %d : %s\n", this.db.errcode(), this.db.errmsg());
				return -1;
			}
			this.create_table_customer();
			return 0;
		}
		
		public bool file_dbcustomer_exist() {
			File file = File.new_for_path(this.pathDBCustomer);
			bool result = file.query_exists();
			return result;
		}
		
		public DataCustomer get_data_customer(int nb) {
			return this.listDataCustomer[nb];
		}
		
		public string get_path_database_customer() {
			return pathDBCustomer;
		}
		
		public int get_number_customer() {
			return this.nbCustomer;
		}

		public int set_path_database_customer(string pathDB) {
			this.pathDBCustomer = pathDB;
			return 0;
		}
	}//end class Customer
	
	/*
	 * Class GuiCustomer
	 */
	 public class GuiCustomer: Customer {
		protected Gtk.Entry entryAccountingCoding;
		protected Gtk.Entry entryCompanyName;
		protected Gtk.Entry entryResponsibleName;
		protected Gtk.Entry entryTenantAddress;
		protected Gtk.Entry entryTenantAddressComplement;
		protected Gtk.Entry entryTenantPostalCode;
		protected Gtk.Entry entryPhoneNumber;
		
		protected Gtk.Entry entryRentedPropertyAddress;
		protected Gtk.Entry entryCadastralPlan;
		protected Gtk.Entry entryBuildingSurface;
		protected Gtk.Entry entryFieldSurface;
		
		protected Gtk.Entry entryRentBeginning;
		protected Gtk.Entry entryRentEnding;
		protected Gtk.ComboBoxText comboboxRentReview;
		protected Gtk.Entry entryAnnualRentPreTax;
		protected Gtk.Entry entryIndexType;
		protected Gtk.Entry entryReferenceQuarter;
		protected Gtk.Entry entryBaseIndex;
		protected Gtk.ComboBoxText comboboxQuarterReview;
		protected Gtk.ComboBoxText comboboxRentPeriodicity;
		
		protected Gtk.Entry entryNewIndex;
		protected Gtk.Entry entryLastIndex;
		protected Gtk.Entry entrySecurityDepositPreTax;
		protected Gtk.Entry entrySecurityDepositIncludedTax;
		protected Gtk.Entry entryProvisionsForExpenses;
		protected Gtk.Entry entryExpensesPaymentReceipt;
		protected Gtk.Entry entryLastAnnualRentalPreTax;
		protected Gtk.Entry entryLastAnnualRentalPreTaxAndPreCharges;
		protected Gtk.Entry entryLastAnnualRentalWithTaxAndPreCharges;
		protected Gtk.Entry entryLastAnnualRentalPreTaxAndCharges;
		protected Gtk.Entry entryLastAnnualRentalWithTaxAndCharges;
		protected Gtk.ComboBoxText comboboxIbanCode;
		
		protected Gtk.Box box;
		
		 public GuiCustomer() {
			this.delete_event.connect(hide_on_delete);
			
			var LabelCompanyName = new Gtk.Label ("Nom de la societe");
			this.entryCompanyName = new Gtk.Entry();
			this.entryCompanyName.set_hexpand(true);
			this.entryCompanyName.set_size_request(-1, 4);
			
			// Label and Entry Info Tenant
			var LabelAccountingCoding = new Gtk.Label ("Code Comptable");
			this.entryAccountingCoding = new Gtk.Entry();
			
			var LabelResponsibleName = new Gtk.Label ("Nom du responsable");
			this.entryResponsibleName = new Gtk.Entry();
			
			var LabelTenantAddress = new Gtk.Label ("Adresse locataire");
			this.entryTenantAddress = new Gtk.Entry();
			
			var LabelTenantAddressComplement = new Gtk.Label ("Complément adresse locataire");
			this.entryTenantAddressComplement = new Gtk.Entry();
			
			var LabelTenantPostalCode = new Gtk.Label ("Code postal locataire");
			this.entryTenantPostalCode = new Gtk.Entry();
			
			var LabelPhoneNumber = new Gtk.Label ("Telephone");
			this.entryPhoneNumber = new Gtk.Entry();
			
			// grid Info Tenant
			var gridInfoTenant = new Gtk.Grid();
			gridInfoTenant.attach(LabelAccountingCoding, 0, 1, 1, 1);
			gridInfoTenant.attach(this.entryAccountingCoding, 1, 1, 1, 1);
			
			gridInfoTenant.attach(LabelCompanyName, 0, 2, 1, 1);
			gridInfoTenant.attach(this.entryCompanyName, 1, 2, 1, 1);
			
			gridInfoTenant.attach(LabelResponsibleName, 0, 3, 1, 1);
			gridInfoTenant.attach(this.entryResponsibleName, 1, 3, 1, 1);
			
			gridInfoTenant.attach(LabelTenantAddress, 0, 4, 1, 1);
			gridInfoTenant.attach(this.entryTenantAddress, 1, 4, 1, 1);
			
			gridInfoTenant.attach(LabelTenantAddressComplement, 0, 5, 1, 1);
			gridInfoTenant.attach(this.entryTenantAddressComplement, 1, 5, 1, 1);
			
			gridInfoTenant.attach(LabelTenantPostalCode, 0, 6, 1, 1);
			gridInfoTenant.attach(this.entryTenantPostalCode, 1, 6, 1, 1);
			
			gridInfoTenant.attach(LabelPhoneNumber, 0, 7, 1, 1);
			gridInfoTenant.attach(this.entryPhoneNumber, 1, 7, 1, 1);
			
			
			// Label and Entry Info Property
			var LabelRentedPropertyAddress = new Gtk.Label ("Adresse du bien loué");
			this.entryRentedPropertyAddress = new Gtk.Entry();
			this.entryRentedPropertyAddress.set_hexpand(true);
			this.entryRentedPropertyAddress.set_size_request(-1, 4);
			
			var LabelCadastralPlan = new Gtk.Label ("Plan cadastral");
			this.entryCadastralPlan = new Gtk.Entry();
			
			var LabelBuildingSurface = new Gtk.Label ("Superficie batiment");
			this.entryBuildingSurface = new Gtk.Entry();
			
			var LabelFieldSurface = new Gtk.Label ("Superficie terrain");
			this.entryFieldSurface = new Gtk.Entry();
			
			// grid info property
			var gridInfoProperty = new Gtk.Grid();
			gridInfoProperty.attach(LabelRentedPropertyAddress, 0, 1, 1, 1);
			gridInfoProperty.attach(this.entryRentedPropertyAddress, 1, 1, 1, 1);
			
			gridInfoProperty.attach(LabelCadastralPlan, 0, 2, 1, 1);
			gridInfoProperty.attach(this.entryCadastralPlan, 1, 2, 1, 1);
			
			gridInfoProperty.attach(LabelBuildingSurface, 0, 3, 1, 1);
			gridInfoProperty.attach(this.entryBuildingSurface, 1, 3, 1, 1);
			
			gridInfoProperty.attach(LabelFieldSurface, 0, 4, 1, 1);
			gridInfoProperty.attach(this.entryFieldSurface, 1, 4, 1, 1);
			
			// Label and Entry Info Contract
			var LabelRentBeginning = new Gtk.Label ("Debut bail (jj/mm/aa)");
			this.entryRentBeginning = new Gtk.Entry();
			this.entryRentBeginning.set_hexpand(true);
			this.entryRentBeginning.set_size_request(-1, 4);
						
			var LabelRentEnding = new Gtk.Label ("Fin bail (jj/mm/aa)");
			this.entryRentEnding = new Gtk.Entry();
				
			var LabelRentReview = new Gtk.Label("Révision du loyer");
			this.comboboxRentReview = new Gtk.ComboBoxText();
			this.comboboxRentReview.append_text("Janvier");
			this.comboboxRentReview.append_text("Février");
			this.comboboxRentReview.append_text("Mars");
			this.comboboxRentReview.append_text("Avril");
			this.comboboxRentReview.append_text("Mai");
			this.comboboxRentReview.append_text("Juin");
			this.comboboxRentReview.append_text("Juillet");
			this.comboboxRentReview.append_text("Août");
			this.comboboxRentReview.append_text("Septembre");
			this.comboboxRentReview.append_text("Octobre");
			this.comboboxRentReview.append_text("Novembre");
			this.comboboxRentReview.append_text("Décembre");
			this.comboboxRentReview.active = 0;

			var LabelAnnualRentPreTax = new Gtk.Label ("Loyer base Annuel H.T");
			this.entryAnnualRentPreTax = new Gtk.Entry();
			
			var LabelIndexType = new Gtk.Label ("Type d'indice");
			this.entryIndexType = new Gtk.Entry();
			
			var LabelReferenceQuarter = new Gtk.Label ("Trimestre de référence");
			this.entryReferenceQuarter = new Gtk.Entry();
			
			var LabelBaseIndex = new Gtk.Label ("Indice de base");
			this.entryBaseIndex = new Gtk.Entry();
			
			var LabelQuarterReview = new Gtk.Label ("Trimestre de revision");
			this.comboboxQuarterReview = new Gtk.ComboBoxText();
			this.comboboxQuarterReview.append_text("1er Trimestre");
			this.comboboxQuarterReview.append_text("2eme Trimestre");
			this.comboboxQuarterReview.append_text("3eme Trimestre");
			this.comboboxQuarterReview.append_text("4eme Trimestre");
			this.comboboxQuarterReview.active = 0;
			
			var LabelRentPeriodicity = new Gtk.Label("Périodicité loyer ");
			this.comboboxRentPeriodicity = new Gtk.ComboBoxText();
			this.comboboxRentPeriodicity.append_text("Mensuelle");
			this.comboboxRentPeriodicity.append_text("Trimestrielle");
			this.comboboxRentPeriodicity.append_text("Semestrielle");
			this.comboboxRentPeriodicity.active = 0;
			
			
			// grid info contract
			var gridInfoContract = new Gtk.Grid();
			gridInfoContract.attach(LabelRentBeginning, 0, 1, 1, 1);
			gridInfoContract.attach(this.entryRentBeginning, 1, 1, 1, 1);
			
			gridInfoContract.attach(LabelRentEnding, 0, 2, 1, 1);
			gridInfoContract.attach(this.entryRentEnding, 1, 2, 1, 1);
			
			gridInfoContract.attach(LabelRentReview, 0, 3, 1, 1);
			gridInfoContract.attach(this.comboboxRentReview, 1, 3, 1, 1);
			
			gridInfoContract.attach(LabelAnnualRentPreTax, 0, 4, 1, 1);
			gridInfoContract.attach(this.entryAnnualRentPreTax, 1, 4, 1, 1);
			
			gridInfoContract.attach(LabelIndexType, 0, 5, 1, 1);
			gridInfoContract.attach(this.entryIndexType, 1, 5, 1, 1);
			
			gridInfoContract.attach(LabelReferenceQuarter, 0, 6, 1, 1);
			gridInfoContract.attach(this.entryReferenceQuarter, 1, 6, 1, 1);
			
			gridInfoContract.attach(LabelBaseIndex, 0, 7, 1, 1);
			gridInfoContract.attach(this.entryBaseIndex, 1, 7, 1, 1);
			
			gridInfoContract.attach(LabelQuarterReview, 0, 8, 1, 1);
			gridInfoContract.attach(this.comboboxQuarterReview, 1, 8, 1, 1);
			
			gridInfoContract.attach(LabelRentPeriodicity, 0, 9, 1, 1);
			gridInfoContract.attach(this.comboboxRentPeriodicity, 1, 9, 1, 1);
			
			// Label and Entry Info Payment
			var LabelNewIndex = new Gtk.Label ("Nouvel indice");
			this.entryNewIndex = new Gtk.Entry();
			this.entryNewIndex.set_hexpand(true);
			this.entryNewIndex.set_size_request(-1, 4);
			
			var LabelLastIndex = new Gtk.Label ("indice précédent");
			this.entryLastIndex = new Gtk.Entry();
			
			var LabelSecurityDepositPreTax = new Gtk.Label ("Depot de garantie H.T");
			this.entrySecurityDepositPreTax = new Gtk.Entry();
			
			var LabelSecurityDepositIncludedTax = new Gtk.Label ("Depot de garantie TTC");
			this.entrySecurityDepositIncludedTax = new Gtk.Entry();
			
			
			var LabelProvisionsForExpenses = new Gtk.Label ("Provisions pour charges");
			this.entryProvisionsForExpenses = new Gtk.Entry();
			
			var LabelExpensesPaymentReceipt = new Gtk.Label ("Paiement charges sur justificatifs");
			this.entryExpensesPaymentReceipt = new Gtk.Entry();
			
			var LabelLastAnnualRentalPreTax = new Gtk.Label ("Montant du dernier loyer annuel H.T");
			this.entryLastAnnualRentalPreTax = new Gtk.Entry();
			
			var LabelLastAnnualRentalPreTaxAndPreCharges = new Gtk.Label ("Montant du dernier loyer HT et HC");
			this.entryLastAnnualRentalPreTaxAndPreCharges = new Gtk.Entry();
			
			var LabelLastAnnualRentalWithTaxAndPreCharges = new Gtk.Label ("Montant du dernier loyer TTC et HC");
			this.entryLastAnnualRentalWithTaxAndPreCharges = new Gtk.Entry();
			
			var LabelLastAnnualRentalPreTaxAndCharges = new Gtk.Label ("Montant loyer HT avec charges");
			this.entryLastAnnualRentalPreTaxAndCharges = new Gtk.Entry();
			
			var LabelLastAnnualRentalWithTaxAndCharges = new Gtk.Label ("loyer TTC avec charges");
			this.entryLastAnnualRentalWithTaxAndCharges = new Gtk.Entry();
			
			var LabelIbanCode = new Gtk.Label ("Code IBAN de la banque");
			this.comboboxIbanCode = new Gtk.ComboBoxText();
			this.comboboxIbanCode.append_text("Code IBAN 1");
			this.comboboxIbanCode.append_text("Code IBAN 2");
			this.comboboxIbanCode.active = 0;

			// grid info payment
			var gridInfoPayment = new Gtk.Grid();
			gridInfoPayment.attach(LabelNewIndex, 0, 1, 1, 1);
			gridInfoPayment.attach(this.entryNewIndex, 1, 1, 1, 1);
			
			gridInfoPayment.attach(LabelLastIndex, 0, 2, 1, 1);
			gridInfoPayment.attach(this.entryLastIndex, 1, 2, 1, 1);
			
			gridInfoPayment.attach(LabelSecurityDepositPreTax, 0, 3, 1, 1);
			gridInfoPayment.attach(this.entrySecurityDepositPreTax, 1, 3, 1, 1);
			
			gridInfoPayment.attach(LabelSecurityDepositIncludedTax, 0, 4, 1, 1);
			gridInfoPayment.attach(this.entrySecurityDepositIncludedTax, 1, 4, 1, 1);
			
			
			gridInfoPayment.attach(LabelProvisionsForExpenses, 0, 5, 1, 1);
			gridInfoPayment.attach(this.entryProvisionsForExpenses, 1, 5, 1, 1);
			
			gridInfoPayment.attach(LabelExpensesPaymentReceipt, 0, 6, 1, 1);
			gridInfoPayment.attach(this.entryExpensesPaymentReceipt, 1, 6, 1, 1);
			
			gridInfoPayment.attach(LabelLastAnnualRentalPreTax, 0, 7, 1, 1);
			gridInfoPayment.attach(this.entryLastAnnualRentalPreTax, 1, 7, 1, 1);
			
			gridInfoPayment.attach(LabelLastAnnualRentalPreTaxAndPreCharges, 0, 8, 1, 1);
			gridInfoPayment.attach(this.entryLastAnnualRentalPreTaxAndPreCharges, 1, 8, 1, 1);
			
			gridInfoPayment.attach(LabelLastAnnualRentalWithTaxAndPreCharges, 0, 9, 1, 1);
			gridInfoPayment.attach(this.entryLastAnnualRentalWithTaxAndPreCharges, 1, 9, 1, 1);
			
			gridInfoPayment.attach(LabelLastAnnualRentalPreTaxAndCharges, 0, 10, 1, 1);
			gridInfoPayment.attach(this.entryLastAnnualRentalPreTaxAndCharges, 1, 10, 1, 1);
			
			gridInfoPayment.attach(LabelLastAnnualRentalWithTaxAndCharges, 0, 11, 1, 1);
			gridInfoPayment.attach(this.entryLastAnnualRentalWithTaxAndCharges, 1, 11, 1, 1);
			
			gridInfoPayment.attach(LabelIbanCode, 0, 12, 1, 1);
			gridInfoPayment.attach(this.comboboxIbanCode, 1, 12, 1, 1);
			
			// label NoteBook
			var labelPageTenant = new Gtk.Label("Informations\nLocataires");
			var labelPageLeasedProperty = new Gtk.Label("Informations\nBien Loué");
			var labelPageContract = new Gtk.Label("Informations\nContrat");
			var labelPagePayment = new Gtk.Label("Informations\nPaiement");
			
			var notebook = new Gtk.Notebook();
			notebook.append_page(gridInfoTenant, labelPageTenant);
			notebook.append_page(gridInfoProperty, labelPageLeasedProperty);
			notebook.append_page(gridInfoContract, labelPageContract);
			notebook.append_page(gridInfoPayment, labelPagePayment);
			

			// Box main
			this.box = new Gtk.Box(Gtk.Orientation.VERTICAL, 0);
			this.box.pack_start(notebook, true, true, 0);

		 }
	 }//end class GuiCustomer
	 
	/*
	 * class AddCustomer
	 */
	public class AddCustomer: GuiCustomer {
		public Gtk.Button buttonAddCustomer;
		
		public void clear_entry() {
			this.entryAccountingCoding.set_text("");
			this.entryCompanyName.set_text("");
			this.entryResponsibleName.set_text("");
			this.entryTenantAddress.set_text("");
			this.entryTenantAddressComplement.set_text("");
			this.entryTenantPostalCode.set_text("");
			this.entryPhoneNumber.set_text("");
			
			this.entryRentedPropertyAddress.set_text("");
			this.entryCadastralPlan.set_text("");
			this.entryBuildingSurface.set_text("");
			this.entryFieldSurface.set_text("");
			
			this.entryRentBeginning.set_text("");
			this.entryRentEnding.set_text("");
			this.comboboxRentReview.set_active(0);
			this.comboboxRentPeriodicity.set_active(0);
			this.entryAnnualRentPreTax.set_text("");
			this.entryIndexType.set_text("");
			this.entryReferenceQuarter.set_text("");
			this.entryBaseIndex.set_text("");
			this.comboboxQuarterReview.set_active(0);
			
			this.entryNewIndex.set_text("");
			this.entryLastIndex.set_text("");
			this.entrySecurityDepositPreTax.set_text("");
			this.entrySecurityDepositIncludedTax.set_text("");
			this.entryProvisionsForExpenses.set_text("");
			this.entryExpensesPaymentReceipt.set_text("");
			this.entryLastAnnualRentalPreTax.set_text("");
			this.entryLastAnnualRentalPreTaxAndPreCharges.set_text("");
			this.entryLastAnnualRentalWithTaxAndPreCharges.set_text("");
			this.entryLastAnnualRentalPreTaxAndCharges.set_text("");
			this.entryLastAnnualRentalWithTaxAndCharges.set_text("");
			this.comboboxIbanCode.set_active(0);
		}
		
		public AddCustomer() {
			this.title = "Ajout Locataire";

			this.buttonAddCustomer = new Gtk.Button.with_label("Enregistrer");
			this.box.pack_start(this.buttonAddCustomer, false, false, 0);

			// signal connect
			this.buttonAddCustomer.clicked.connect( () => {
				print("Bouton Ajouter Locataire\n");
				print("Base de donnee : %s\n", this.pathDBCustomer);
			
				this.dataCustomer.AccountingCoding = this.entryAccountingCoding.get_text();
				this.dataCustomer.CompanyName = this.entryCompanyName.get_text();
				this.dataCustomer.ResponsibleName = this.entryResponsibleName.get_text();
				this.dataCustomer.TenantAddress = this.entryTenantAddress.get_text();
				this.dataCustomer.TenantAddressComplement = this.entryTenantAddressComplement.get_text();
				this.dataCustomer.TenantPostalCode = this.entryTenantPostalCode.get_text();
				this.dataCustomer.PhoneNumber = this.entryPhoneNumber.get_text();
								
				this.dataCustomer.RentedPropertyAddress = this.entryRentedPropertyAddress.get_text();
				this.dataCustomer.CadastralPlan = this.entryCadastralPlan.get_text();
				this.dataCustomer.BuildingSurface = this.entryBuildingSurface.get_text();
				this.dataCustomer.FieldSurface = this.entryFieldSurface.get_text();
				
				this.dataCustomer.RentBeginning = this.entryRentBeginning.get_text();
				this.dataCustomer.RentEnding = this.entryRentEnding.get_text();
				this.dataCustomer.RentReview = this.comboboxRentReview.get_active_text();
				this.dataCustomer.AnnualRentPreTax = this.entryAnnualRentPreTax.get_text();
				this.dataCustomer.IndexType = this.entryIndexType.get_text();
				this.dataCustomer.ReferenceQuarter = this.entryReferenceQuarter.get_text();
				this.dataCustomer.BaseIndex = this.entryBaseIndex.get_text();
				this.dataCustomer.QuarterReview = this.comboboxQuarterReview.get_active_text();
				this.dataCustomer.RentPeriodicity = this.comboboxRentPeriodicity.get_active_text();
				
				this.dataCustomer.NewIndex = this.entryNewIndex.get_text();
				this.dataCustomer.LastIndex = this.entryLastIndex.get_text();
				this.dataCustomer.SecurityDepositPreTax = this.entrySecurityDepositPreTax.get_text();
				this.dataCustomer.SecurityDepositIncludedTax = this.entrySecurityDepositIncludedTax.get_text();
				this.dataCustomer.ProvisionsForExpenses = this.entryProvisionsForExpenses.get_text();
				this.dataCustomer.ExpensesPaymentReceipt = this.entryExpensesPaymentReceipt.get_text();
				this.dataCustomer.LastAnnualRentalPreTax = this.entryLastAnnualRentalPreTax.get_text();
				this.dataCustomer.LastAnnualRentalPreTaxAndPreCharges = this.entryLastAnnualRentalPreTaxAndPreCharges.get_text();
				this.dataCustomer.LastAnnualRentalWithTaxAndPreCharges = this.entryLastAnnualRentalWithTaxAndPreCharges.get_text();
				this.dataCustomer.LastAnnualRentalPreTaxAndCharges = this.entryLastAnnualRentalPreTaxAndCharges.get_text();
				this.dataCustomer.LastAnnualRentalWithTaxAndCharges = this.entryLastAnnualRentalWithTaxAndCharges.get_text();
				this.dataCustomer.IbanCode = this.comboboxIbanCode.get_active_text();
				
//				this.display_data_customer();
				this.insert_table_customer();
				this.set_visible(false);
			});
			
			this.add(box);
		}
		
		public void show_add_customer() {
			this.show_all();
		}
	}//end class AddCustomer
	
	/*
	 * Class SaveCustomer
	 */
	public class SaveCustomer: Customer {
		private Gtk.FileChooserDialog saveDialog;
		
		public SaveCustomer() {
			this.saveDialog = new Gtk.FileChooserDialog(
				"Enregistrer le nom du fichier", this as Gtk.Window,
				Gtk.FileChooserAction.SAVE,
				"_Cancel", Gtk.ResponseType.CANCEL,
				"_Enregistrer",
				Gtk.ResponseType.ACCEPT
			);
			
			if ( this.saveDialog.run() == Gtk.ResponseType.ACCEPT ) {
				print("Bouton Enregistrer\n");
				this.pathDBCustomer = this.saveDialog.get_current_folder().concat(
					"/", this.saveDialog.get_current_name(), null
				);
				this.create_database();
			}//end if
			
			this.saveDialog.close();
			this.saveDialog.show();
		}//end SaveCustomer
	}//end class SavecCustomer
	
	/*
	 * Class DeleteCustomer
	 */
	 public class DeleteCustomer: Customer {
		 public Gtk.Button buttonDelete;
		 
		 private Gtk.Button buttonCancel;
		 private Gtk.ListBox listbox;
		 
		 private int nbSelected;
		 
		 public int refresh_view_delete_customer() {
			 // Delete all old widget of grid
			foreach (Gtk.Widget element in this.listbox.get_children())
			this.listbox.remove(element);
			
			 this.select_table_customer();
			 int nbCustomer = this.get_number_customer();
			 print("DB dans DeleteCustomer : %s\n", this.pathDBCustomer);
			 print("Nombre Locataire : %d\n", nbCustomer);
			 
			 for (int i=0; i<nbCustomer;i++) {
				 print("Nom Compagnie: %s\n", listDataCustomer[i].CompanyName);
				 var labelNC = new Gtk.Label(listDataCustomer[i].CompanyName);
				 this.listbox.insert(labelNC, i);
			 }
			 this.listbox.show_all();
			 return 0;
		 }
		 
		 public DeleteCustomer() {
			 this.title = "Supprimer un Locataire";
			 this.set_default_size(300, 200);
			 this.delete_event.connect(hide_on_delete);
			 
			this.listbox = new Gtk.ListBox();
			 
			 var scroll = new ScrolledWindow(null, null);
			 scroll.add(this.listbox);
			 
			 this.buttonDelete = new Gtk.Button.with_label("Supprimer");
			 this.buttonCancel = new Gtk.Button.with_label("Annuler");
			 var boxButton = new Gtk.Box(Gtk.Orientation.VERTICAL, 0);
			 boxButton.pack_start(buttonDelete, false, false);
			 boxButton.pack_start(buttonCancel, false, false);
			 
			 var boxMain = new Gtk.Box(Gtk.Orientation.HORIZONTAL, 0);
			 boxMain.pack_start(scroll, true, true);
			 boxMain.pack_start(boxButton, false, false);
			 add(boxMain);
			
			/*
			 * Signal connect
			 */
			this.buttonDelete.clicked.connect( () => {
				print("Suppresionn du Locataire numero : %d %s\n",
						this.nbSelected, this.listDataCustomer[nbSelected].CompanyName);
				this.delete_table_customer(this.listDataCustomer[nbSelected].CompanyName);
				this.refresh_view_delete_customer();
			});
			 this.buttonCancel.clicked.connect( () => {
				 this.visible = false;
			});
			this.listbox.row_activated.connect( () => {
				Gtk.ListBoxRow lbr = this.listbox.get_selected_row();
				this.nbSelected = lbr.get_index();
			});
		 }//end DeleteCustomer
		 
		 public void show_delete_customer() {
			 this.show_all();
		 }
	 }//end class DeleteCustomer
	 
	 /*
	  * Class Edit Customer
	  */
	 public class EditCustomer: GuiCustomer {
		 public Gtk.Button buttonEditCustomer;
		 
		 public int update_customer(DataCustomer c) {
			 int res = Sqlite.Database.open(this.pathDBCustomer, out this.db);
			if ( res != Sqlite.OK ) {
				print("Error : %d : %s\n", this.db.errcode(), this.db.errmsg());
				return -1;
			}
			
			string query="UPDATE Customer SET "+
				"AccountingCoding = '"+this.dataCustomer.AccountingCoding+"',"+
				"CompanyName = '"+this.dataCustomer.CompanyName+"',"+
				"ResponsibleName = '"+this.dataCustomer.ResponsibleName+"' "+
				"WHERE CompanyName = '"+this.dataCustomer.CompanyName+"';";
				
				print("Requete %s\n", query);
			res = this.db.exec(query, null, out this.errmsg);
			if (res != Sqlite.OK) {
				print("Erreur %s\n", this.errmsg);
				return -1;
			}
			
			 return 0;
		 }
		 
		 public void show_edit_customer(DataCustomer c) {
			 print("Nom société : %s\n", c.CompanyName);
			 this.entryAccountingCoding.set_text(c.AccountingCoding);
			 this.entryCompanyName.set_text(c.CompanyName);
			 this.entryResponsibleName.set_text(c.ResponsibleName);
			 this.entryTenantAddress.set_text(c.TenantAddress);
			 this.entryTenantAddressComplement.set_text(c.TenantAddressComplement);
			 this.entryTenantPostalCode.set_text(c.TenantPostalCode);
			 this.entryPhoneNumber.set_text(c.PhoneNumber);
			 
			 this.entryRentedPropertyAddress.set_text(c.RentedPropertyAddress);
			 print("adresse bien louée : %s\n", c.RentedPropertyAddress);
			 this.entryCadastralPlan.set_text(c.CadastralPlan);
			 this.entryBuildingSurface.set_text(c.BuildingSurface);
			 this.entryFieldSurface.set_text(c.FieldSurface);
			 
			 this.entryRentBeginning.set_text(c.RentBeginning);
			 this.entryRentEnding.set_text(c.RentEnding);
			this.comboboxRentReview.active = INT_MONTH(c.RentReview);

			 this.comboboxRentPeriodicity.active = INT_RENTPERIODICITY(c.RentPeriodicity);
			 this.entryAnnualRentPreTax.set_text(c.AnnualRentPreTax);
			 this.entryIndexType.set_text(c.IndexType);
			 this.entryReferenceQuarter.set_text(c.ReferenceQuarter);
			 this.entryBaseIndex.set_text(c.BaseIndex);
			 this.comboboxQuarterReview.active = INT_QUARTERREVIEW(c.QuarterReview);
			 
			 this.entryNewIndex.set_text(c.NewIndex);
			 this.entryLastIndex.set_text(c.LastIndex);
			 this.entrySecurityDepositPreTax.set_text(c.SecurityDepositPreTax);
			 this.entrySecurityDepositIncludedTax.set_text(c.SecurityDepositIncludedTax);
			 this.entryProvisionsForExpenses.set_text(c.ProvisionsForExpenses);
			 this.entryExpensesPaymentReceipt.set_text(c.ExpensesPaymentReceipt);
			 this.entryLastAnnualRentalPreTax.set_text(c.LastAnnualRentalPreTax);
			 this.entryLastAnnualRentalPreTaxAndPreCharges.set_text(c.LastAnnualRentalPreTaxAndPreCharges);
			 this.entryLastAnnualRentalWithTaxAndPreCharges.set_text(c.LastAnnualRentalWithTaxAndPreCharges);
			 this.entryLastAnnualRentalPreTaxAndCharges.set_text(c.LastAnnualRentalPreTaxAndCharges);
			 this.entryLastAnnualRentalWithTaxAndCharges.set_text(c.LastAnnualRentalWithTaxAndCharges);
			 this.comboboxIbanCode.active = INT_CODEIBAN(c.IbanCode);
			 
			 this.show_all();
		 }
		 
		 public EditCustomer() {
			 this.title = "Modification d'un Locataire";
			 this.buttonEditCustomer = new Gtk.Button.with_label("Enregistrer les modifications");
			 this.box.pack_start(this.buttonEditCustomer, false, false, 0);
			 
			 this.buttonEditCustomer.clicked.connect( ()=> {
				 var res = this.update_customer(this.dataCustomer);
				 if (res==0) {
					print("Enregistrement Modification\n");
				 } else {
					 print("Probleme dans l'enregistrement des modifications\n");
				 }
				});
			 this.add(this.box);
		 }
	 }//end class EditCustomer
}//end namespace Customer
