namespace BillingType {
	public enum Periodicity {
		BAD, MONTHLY, QUARTERLY, BIANNUAL
	}
	
	public struct CustomerByMonth {
		int january;
		int february;
		int march;
		int april;
		int may;
		int june;
		int july;
		int august;
		int september;
		int october;
		int november;
		int december;
	}
	
	public void display_customer_by_month(CustomerByMonth cbm) {
		print("Janvier %d\tFevrier %d\tMars %d\tAvril %d\tMai %d\n", 
			cbm.january, cbm.february, cbm.march, cbm.april, cbm.may);
	}
	
	public void increment_month(int nb_month, ref CustomerByMonth cbm) {
		switch (nb_month) {
			case -1:
				cbm={0,0,0,0,0,0,0,0,0,0,0,0};
				break;
			case 1:
				cbm.january++;//cbm.january+1;
				break;
			case 2:
				cbm.february++;
				break;
			case 3:
				cbm.march++;
				break;
			case 4:
				cbm.april++;
				break;
			case 5:
				cbm.may++;
				break;
			case 6:
				cbm.june++;
				break;
			case 7:
				cbm.july++;
				break;
			case 8:
				cbm.august++;
				break;
			case 9:
				cbm.september++;
				break;
			case 10:
				cbm.october++;
				break;
			case 11:
				cbm.november++;
				break;
			case 12:
				cbm.december++;
				break;
			case 13:
				cbm.january++;
				cbm.february++;
				cbm.march++;
				cbm.april++;
				cbm.may++;
				cbm.june++;
				cbm.july++;
				cbm.august++;
				cbm.september++;
				cbm.october++;
				cbm.november++;
				cbm.december++;
				break;
			default:
				cbm={0,0,0,0,0,0,0,0,0,0,0,0};
				break;	
		}//end switch
	}
	
	public int number_month_fr(string month_fr) {
		switch (month_fr) {
			case "Janvier":
				return 0;
			case "Février":
				return 1;
			case "Mars":
				return 2;
			case "Avril":
				return 3;
			case "Mai":
				return 4;
			case "Juin":
				return 5;
			case "Juillet":
				return 6;
			case "Août":
				return 7;
			case "Septembre":
				return 8;
			case "Octobre":
				return 9;
			case "Novembre":
				return 10;
			case "Décembre":
				return 11;
		}//end switch
		return -1;
	}
	
	public int INT_CODEIBAN(string iban) {
		switch (iban) {
			case "Code IBAN 1":
				return 0;
			case "Code IBAN 2":
				return 1;
		}//end switch
		return -1;
	}
	
	public int INT_MONTH(string month) {
		switch (month) {
			case "JANUARY":
				return 0;
			case "FEBRUARY":
				return 1;
			case "MARCH":
				return 2;
			case "APRIL":
				return 3;
			case "MAY":
				return 4;
			case "JUNE":
				return 5;
			case "JULY":
				return 6;
			case "AUGUST":
				return 7;
			case "SEPTEMBER":
				return 8;
			case "OCTOBER":
				return 9;
			case "NOVEMBER":
				return 10;
			case "DECEMBER":
				return 11;
		}//end switch
		return -1;		
	}
	
	public int INT_QUARTERREVIEW(string quarter) {
		switch (quarter) {
			case "1er Trimestre":
				return 0;
			case "2eme Trimestre":
				return 1;
			case "3eme Trimestre":
				return 2;
			case "4eme Trimestre":
				return 3;
		}//end switch
		return -1;
	}
	
	public int INT_RENTPERIODICITY(string periodicity) {
		switch (periodicity) {
			case "Mensuelle":
				return 0;
			case "Trimestrielle":
				return 1;
			case "Semestrielle":
				return 2;
		}//end switch
		return -1;
	}
	
}
