using BillingType;

namespace Billing {
		/*
		public enum Periodicity {
			MONTHLY, QUARTERLY, BIANNUAL
		}
		*/
	public class Billing:Gtk.Window {
		private Gtk.Label labelCompanyName;
		private Gtk.Label labelMonth;
		private Gtk.Label labelAnnualRentPreTax;
		
		private List <DateMonth> listMonths;
		
		public void display_list_months_billable(List <DateMonth> _listMonths) {
			foreach (DateMonth dm in _listMonths) {
				print("%d %s\n", dm, dm.to_string());
			}
		}
		
		public DateMonth get_date_month_fr_to_en(string month_fr) {
			DateMonth month = DateMonth.JANUARY;
			switch(month_fr) {
				case "Janvier":
					month = DateMonth.JANUARY;
					break;
				case "Février":
					month = DateMonth.FEBRUARY;
					break;
				case "Mars":
					month = DateMonth.MARCH;
					break;
				case "Avril":
					month = DateMonth.APRIL;
					break;
				case "Mai":
					month = DateMonth.MAY;
					break;
				case "Juin":
					month = DateMonth.JUNE;
					break;
				case "Juillet":
					month = DateMonth.JULY;
					break;
				case "Août":
					month = DateMonth.AUGUST;
					break;
				case "Septembre":
					month = DateMonth.SEPTEMBER;
					break;
				case "Octobre":
					month = DateMonth.OCTOBER;
					break;
				case "Novembre":
					month = DateMonth.NOVEMBER;
					break;
				case "Décembre":
					month = DateMonth.DECEMBER;
					break;
			}
			return month;
		}
		
		public DateMonth convert_string_to_date_month(string smonth) {
			DateMonth month = DateMonth.JANUARY;
			switch(smonth) {
				case "JANUARY":
					month = DateMonth.JANUARY;
					break;
				case "FEBRUARY":
					month = DateMonth.FEBRUARY;
					break;
				case "MARCH":
					month = DateMonth.MARCH;
					break;
				case "APRIL":
					month = DateMonth.APRIL;
					break;
				case "MAY":
					month = DateMonth.MAY;
					break;
				case "JUNE":
					month = DateMonth.JUNE;
					break;
				case "JULY":
					month = DateMonth.JULY;
					break;
				case "AUGUST":
					month = DateMonth.AUGUST;
					break;
				case "SEPTEMBER":
					month = DateMonth.SEPTEMBER;
					break;
				case "OCTOBER":
					month = DateMonth.OCTOBER;
					break;
				case "NOVEMBER":
					month = DateMonth.NOVEMBER;
					break;
				case "DECEMBER":
					month = DateMonth.DECEMBER;
					break;
			}
			return month;
		}
		
		public string convert_date_month_to_string_fr(DateMonth month) {
			string month_fr = "Janvier";
			switch (month) {
				case DateMonth.JANUARY:
					month_fr = "Janvier";
					break;
				case DateMonth.FEBRUARY:
					month_fr = "Février";
					break;
				case DateMonth.MARCH:
					month_fr = "Mars";
					break;
				case DateMonth.APRIL:
					month_fr = "Avril";
					break;
				case DateMonth.MAY:
					month_fr = "Mai";
					break;
				case DateMonth.JUNE:
					month_fr = "Juin";
					break;
				case DateMonth.JULY:
					month_fr = "Juillet";
					break;
				case DateMonth.AUGUST:
					month_fr = "Août";
					break;
				case DateMonth.SEPTEMBER:
					month_fr = "Septembre";
					break;
				case DateMonth.OCTOBER:
					month_fr = "Octobre";
					break;
				case DateMonth.NOVEMBER:
					month_fr = "Novembre";
					break;
				case DateMonth.DECEMBER:
					month_fr = "Décembre";
					break;
			}
			
			return month_fr;
		}
		
		public Periodicity get_periodicity(string periodicity) {
			switch (periodicity) {
				case "Mensuelle":
					return Periodicity.MONTHLY;
				case "Trimestrielle":
					return Periodicity.QUARTERLY;
				case "Semestrielle":
					return Periodicity.BIANNUAL;
			}
			return Periodicity.BAD;
		}
		
		public List<DateMonth> get_list_months_billable(Periodicity rentP, DateMonth rentReview) {
		// Remove all list's items
			this.listMonths.remove_all(DateMonth.JANUARY);
			this.listMonths.remove_all(DateMonth.FEBRUARY);
			this.listMonths.remove_all(DateMonth.MARCH);
			this.listMonths.remove_all(DateMonth.APRIL);
			this.listMonths.remove_all(DateMonth.MAY);
			this.listMonths.remove_all(DateMonth.JUNE);
			this.listMonths.remove_all(DateMonth.JULY);
			this.listMonths.remove_all(DateMonth.AUGUST);
			this.listMonths.remove_all(DateMonth.SEPTEMBER);
			this.listMonths.remove_all(DateMonth.OCTOBER);
			this.listMonths.remove_all(DateMonth.NOVEMBER);
			this.listMonths.remove_all(DateMonth.DECEMBER);


			// if periodicity is MONTHLY then return immediatly all months
			if (rentP == Periodicity.MONTHLY) {
				this.listMonths.append(DateMonth.JANUARY);
				this.listMonths.append(DateMonth.FEBRUARY);
				this.listMonths.append(DateMonth.MARCH);
				this.listMonths.append(DateMonth.APRIL);
				this.listMonths.append(DateMonth.MAY);
				this.listMonths.append(DateMonth.JUNE);
				this.listMonths.append(DateMonth.JULY);
				this.listMonths.append(DateMonth.AUGUST);
				this.listMonths.append(DateMonth.SEPTEMBER);
				this.listMonths.append(DateMonth.OCTOBER);
				this.listMonths.append(DateMonth.NOVEMBER);
				this.listMonths.append(DateMonth.DECEMBER);
				
				return this.listMonths.copy();
			}
				
			switch (rentP) {
				case Periodicity.QUARTERLY:
					if ( (rentReview == 1) || (rentReview == 4) || 
								(rentReview == 7) || (rentReview == 10)) {
						print("Trimestrielle Janvier/Avril/Juillet/Octobre\n");
						this.listMonths.append(DateMonth.JANUARY);
						this.listMonths.append(DateMonth.APRIL);
						this.listMonths.append(DateMonth.JULY);
						this.listMonths.append(DateMonth.OCTOBER);
					}
					if ( (rentReview == 2) || (rentReview == 5) || 
								(rentReview == 8) || (rentReview == 11)) {
						print("Trimestrielle Février/Mai/Aout/Novembre\n");
						this.listMonths.append(DateMonth.FEBRUARY);
						this.listMonths.append(DateMonth.MAY);
						this.listMonths.append(DateMonth.AUGUST);
						this.listMonths.append(DateMonth.NOVEMBER);
					}
					if ( (rentReview == 3) || (rentReview == 6) || 
								(rentReview == 9) || (rentReview == 12)) {
						print("Trimestrielle Mars/Juin/Septembre/Decembre\n");
						this.listMonths.append(DateMonth.MARCH);
						this.listMonths.append(DateMonth.JUNE);
						this.listMonths.append(DateMonth.SEPTEMBER);
						this.listMonths.append(DateMonth.DECEMBER);
					}
					break;
				case Periodicity.BIANNUAL:
					if ( (rentReview == 1) || (rentReview == 7) ) {
						this.listMonths.append(DateMonth.JANUARY);
						this.listMonths.append(DateMonth.JULY);
					}
					if ( (rentReview == 2) | (rentReview == 8) ) {
						this.listMonths.append(DateMonth.FEBRUARY);
						this.listMonths.append(DateMonth.AUGUST);
					}
					if ( (rentReview == 3) || (rentReview == 9) ) {
						this.listMonths.append(DateMonth.MARCH);
						this.listMonths.append(DateMonth.SEPTEMBER);
					}
					if ( (rentReview == 4) || (rentReview == 10) ) {
						this.listMonths.append(DateMonth.APRIL);
						this.listMonths.append(DateMonth.OCTOBER);
					}
					if ( (rentReview == 5) || (rentReview == 11) ) {
						this.listMonths.append(DateMonth.MAY);
						this.listMonths.append(DateMonth.NOVEMBER);
					}
					if ( (rentReview == 6) || (rentReview == 12) ) {
						this.listMonths.append(DateMonth.JUNE);
						this.listMonths.append(DateMonth.DECEMBER);
					}
					break;
			}//end switch
			
			return this.listMonths.copy();
		}//end get_list_months_billable
	
		public void show_billing() {
			this.show_all();
		}
		
		public void set_label_annual_rent_pre_tax(string arp) {
			this.labelAnnualRentPreTax.set_text("Loyer Annuel HT "+arp +"€");
		}
		
		public void set_label_company_name(string companyName) {
			this.labelCompanyName.set_text("Société "+companyName);
		}
		
		public void set_label_month(DateMonth month) {
			string month_fr = this.convert_date_month_to_string_fr(month);
			this.labelMonth.set_text("Facture de "+month_fr);
		}
		
		// constructor
		public Billing() {
			this.set_title("Facturation");
			this.delete_event.connect(hide_on_delete);
//			this.has_toplevel_focus(true);
			
			this.labelCompanyName = new Gtk.Label("Nom Locataire");
			this.labelMonth = new Gtk.Label("Mois");
			this.labelAnnualRentPreTax = new Gtk.Label("Loyer annuel HT");
			
			var boxMain = new Gtk.Box(Gtk.Orientation.VERTICAL, 0);
			boxMain.pack_start(labelCompanyName, true, true);
			boxMain.pack_start(labelMonth, true, true);
			boxMain.pack_start(labelAnnualRentPreTax, true, true);
			this.add(boxMain);
		}
	}//end class Billing
}//end namespace Billing
