using Billing;
using Customer;
using BillingType;

public static int main(string[] args) {
	Gtk.init(ref args);
	var billing = new Billing.Billing();
	var customer = new Customer.Customer();

	customer.set_path_database_customer("default_customer.db");

	int res = customer.select_table_customer();
	if (res==0) {
		print("Ok select\n");
	} else {
		print("Erreur select\n");
		return -1;
	}
	
	
	var dataCustomer = customer.get_data_customer(6);
	print("Nom societe : %s\n", dataCustomer.CompanyName);

	billing.set_data_customer(dataCustomer, DateMonth.JANUARY);
	
	billing.create_pdf();

//	Gtk.main_quit();
	Gtk.main();
	return 0;
}
