using Cairo;

public int main() {
	const int MARGIN_LEFT = 40;
	const int MARGIN_TOP = 20;
	
	const int TENANT_LEFT = 310;
	const int TENANT_TOP = 150;
	
	const int HEIGHT = 18;
	
	const int DESCRIPTION_TOP = 300;
	
	const int STEP_Y = 15;
	
	const int STEP_YD = 12;
	
	string filename = "test.pdf";
	string path_logo = "logo.png";
	
	Cairo.Surface logo = new Cairo.ImageSurface.from_png(path_logo);
	
	
	Cairo.Surface surface = new PdfSurface (filename, 596, 842);
	Cairo.Context contextCairo = new Cairo.Context(surface);
	
	
	
	contextCairo.set_font_size(11);
	
	contextCairo.move_to(TENANT_LEFT, TENANT_TOP);
	contextCairo.show_text("entreprise");
	
	contextCairo.move_to(TENANT_LEFT, TENANT_TOP+STEP_Y);
	contextCairo.show_text("nom");
	
	contextCairo.move_to(TENANT_LEFT, TENANT_TOP+STEP_Y*2);
	contextCairo.show_text("adresse");
	
	contextCairo.move_to(TENANT_LEFT, TENANT_TOP+STEP_Y*3);
	contextCairo.show_text("complément d'adresse");
	
	contextCairo.move_to(TENANT_LEFT, TENANT_TOP+STEP_Y*4);
	contextCairo.show_text("code postal et ville");
	
	contextCairo.move_to(TENANT_LEFT-STEP_Y*17, TENANT_TOP+STEP_Y*5);
	contextCairo.show_text("adresse mail entreprise");
	
	contextCairo.move_to(TENANT_LEFT, TENANT_TOP+STEP_Y*7+10);
	contextCairo.show_text("fait à... le 1er...");
	
	// Facture
	contextCairo.select_font_face("Sans-Regular", Cairo.FontSlant.NORMAL, Cairo.FontWeight.BOLD);
	contextCairo.move_to(MARGIN_LEFT, DESCRIPTION_TOP);
	contextCairo.show_text("Facture : 2019/...");
	
	//Description
	contextCairo.select_font_face("Courrier", Cairo.FontSlant.NORMAL, Cairo.FontWeight.NORMAL);
	contextCairo.move_to(MARGIN_LEFT+5, DESCRIPTION_TOP+STEP_Y*2);
	contextCairo.show_text("Conformément au bail notarié du (date de signature du bail) prenant effet le (date de début de bail)");
	
	contextCairo.move_to(MARGIN_LEFT+5, DESCRIPTION_TOP+STEP_Y*2+STEP_YD);
	contextCairo.show_text("pour se terminer le (date de fin de bail) pour la location d'un");
	
	contextCairo.move_to(MARGIN_LEFT+5, DESCRIPTION_TOP+STEP_Y*2+STEP_YD*2);
	contextCairo.show_text("enssemble immobilier situé commune de Toulouse (Haute Garonne),(adresse bien loué)");
	
	contextCairo.move_to(MARGIN_LEFT+5, DESCRIPTION_TOP+STEP_Y*2+STEP_YD*3);
	contextCairo.show_text("consistant en un local de (superficie terrain)m² au sol.");
	
	contextCairo.select_font_face("Sans-Regular", Cairo.FontSlant.NORMAL, Cairo.FontWeight.BOLD);
	contextCairo.move_to(MARGIN_LEFT+5, DESCRIPTION_TOP+STEP_Y*2+STEP_YD*4);
	contextCairo.show_text("le loyer est payable par trimestre et d'avance le premier jour du premier mois :");
	
	contextCairo.select_font_face("Sans-Regular", Cairo.FontSlant.NORMAL, Cairo.FontWeight.BOLD);
	contextCairo.move_to(MARGIN_LEFT+5, DESCRIPTION_TOP+STEP_Y*2+STEP_YD*7);
	contextCairo.show_text("loyer (trimetre de facturation et année)");
	
	
	
	contextCairo.select_font_face("", Cairo.FontSlant.NORMAL, Cairo.FontWeight.NORMAL);
	contextCairo.set_source_rgb(0, 0, 0);
	contextCairo.rectangle(MARGIN_LEFT+STEP_Y*5, DESCRIPTION_TOP+STEP_Y*9, STEP_Y*25, HEIGHT*7 );// génération rectangle
	
	
	
	contextCairo.stroke();
	
	contextCairo.set_source_surface(logo, MARGIN_LEFT, MARGIN_TOP);
	contextCairo.paint();
	
		contextCairo.set_source_rgb(0, 0, 0);
	// début génération ligne verticale
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*22, DESCRIPTION_TOP+STEP_Y*9);
	contextCairo.line_to(MARGIN_LEFT+STEP_Y*22, DESCRIPTION_TOP+STEP_Y*9 + HEIGHT*7); 
	// fin génération ligne verticale
	
	contextCairo.set_font_size(12);
	
	// génération ligne horizontale + écriture dans le tableau
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*5, DESCRIPTION_TOP+STEP_Y*10);
	contextCairo.line_to(MARGIN_LEFT+STEP_Y*30, DESCRIPTION_TOP+STEP_Y*10);
	
	contextCairo.select_font_face("Sans-Regular", Cairo.FontSlant.NORMAL, Cairo.FontWeight.BOLD);
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*24, DESCRIPTION_TOP+STEP_Y*9.7);
	contextCairo.show_text("Euros");
	
	contextCairo.select_font_face("Sans-Regular", Cairo.FontSlant.NORMAL, Cairo.FontWeight.NORMAL);
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*5, DESCRIPTION_TOP+STEP_Y*10 + HEIGHT);
	contextCairo.line_to(MARGIN_LEFT+STEP_Y*30, DESCRIPTION_TOP+STEP_Y*10 + HEIGHT);
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*5+5, DESCRIPTION_TOP+STEP_Y*9.7 + HEIGHT);
	contextCairo.show_text("Total de la période");
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*24, DESCRIPTION_TOP+STEP_Y*9.7 + HEIGHT);
	contextCairo.show_text("12345");
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*5, DESCRIPTION_TOP+STEP_Y*10 + HEIGHT*2);
	contextCairo.line_to(MARGIN_LEFT+STEP_Y*30, DESCRIPTION_TOP+STEP_Y*10 + HEIGHT*2);
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*5+5, DESCRIPTION_TOP+STEP_Y*9.7 + HEIGHT*2);
	contextCairo.show_text("Provisions pour charges");
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*24, DESCRIPTION_TOP+STEP_Y*9.7 + HEIGHT*2);
	contextCairo.show_text("12345");
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*5, DESCRIPTION_TOP+STEP_Y*10 + HEIGHT*3);
	contextCairo.line_to(MARGIN_LEFT+STEP_Y*30, DESCRIPTION_TOP+STEP_Y*10 + HEIGHT*3);
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*5+5, DESCRIPTION_TOP+STEP_Y*9.7 + HEIGHT*3);
	contextCairo.show_text(" ");
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*5, DESCRIPTION_TOP+STEP_Y*10 + HEIGHT*4);
	contextCairo.line_to(MARGIN_LEFT+STEP_Y*30, DESCRIPTION_TOP+STEP_Y*10 + HEIGHT*4);
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*5+5, DESCRIPTION_TOP+STEP_Y*9.7 + HEIGHT*4);
	contextCairo.show_text("Total H.T.");
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*24, DESCRIPTION_TOP+STEP_Y*9.7 + HEIGHT*4);
	contextCairo.show_text("12345");
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*5, DESCRIPTION_TOP+STEP_Y*10 + HEIGHT*5);
	contextCairo.line_to(MARGIN_LEFT+STEP_Y*30, DESCRIPTION_TOP+STEP_Y*10 + HEIGHT*5);
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*5+5, DESCRIPTION_TOP+STEP_Y*9.7 + HEIGHT*5);
	contextCairo.show_text("TVA 20%");
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*24, DESCRIPTION_TOP+STEP_Y*9.7 + HEIGHT*5);
	contextCairo.show_text("12345");
	
	contextCairo.select_font_face("Sans-Regular", Cairo.FontSlant.NORMAL, Cairo.FontWeight.BOLD);
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*5+5, DESCRIPTION_TOP+STEP_Y*9.7 + HEIGHT*6);
	contextCairo.show_text("Total T.T.C.");
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*24, DESCRIPTION_TOP+STEP_Y*9.7 + HEIGHT*6);
	contextCairo.show_text("12345");
	/* 
	 *fin tableau 1
	 */
	contextCairo.set_font_size(10);
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y, DESCRIPTION_TOP+STEP_Y*19);
	contextCairo.show_text("SOMME A NOUS REGLER LE 1 (DATE)");
	
	
	contextCairo.rectangle(MARGIN_LEFT+STEP_Y, DESCRIPTION_TOP + STEP_Y*20, STEP_Y*32, HEIGHT*6 );// génération rectangle tableau 2
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*15, DESCRIPTION_TOP+STEP_Y*20+ HEIGHT);
	contextCairo.line_to(MARGIN_LEFT+STEP_Y*15, DESCRIPTION_TOP+STEP_Y*20 + HEIGHT*6);
	//génération ligne verticale
	
	// génération ligne horizontale + écriture dans le tableau
	contextCairo.move_to(MARGIN_LEFT+STEP_Y, DESCRIPTION_TOP+STEP_Y*20+HEIGHT);
	contextCairo.line_to(MARGIN_LEFT+STEP_Y*33, DESCRIPTION_TOP+STEP_Y*20+HEIGHT);
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*10+5, DESCRIPTION_TOP+STEP_Y*19.7 + HEIGHT);
	contextCairo.show_text("Relvé d'identité bancaire");
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y, DESCRIPTION_TOP+STEP_Y*20+HEIGHT*2);
	contextCairo.line_to(MARGIN_LEFT+STEP_Y*33, DESCRIPTION_TOP+STEP_Y*20+HEIGHT*2);
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y+5, DESCRIPTION_TOP+STEP_Y*19.7 + HEIGHT*2);
	contextCairo.show_text("Titulaire");
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y, DESCRIPTION_TOP+STEP_Y*20+HEIGHT*3);
	contextCairo.line_to(MARGIN_LEFT+STEP_Y*33, DESCRIPTION_TOP+STEP_Y*20+HEIGHT*3);
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y+5, DESCRIPTION_TOP+STEP_Y*19.7 + HEIGHT*3);
	contextCairo.show_text("Domiciliation");
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y, DESCRIPTION_TOP+STEP_Y*20+HEIGHT*4);
	contextCairo.line_to(MARGIN_LEFT+STEP_Y*33, DESCRIPTION_TOP+STEP_Y*20+HEIGHT*4);
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y+5, DESCRIPTION_TOP+STEP_Y*19.7 + HEIGHT*4);
	contextCairo.show_text("RIB");
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y, DESCRIPTION_TOP+STEP_Y*20+HEIGHT*5);
	contextCairo.line_to(MARGIN_LEFT+STEP_Y*33, DESCRIPTION_TOP+STEP_Y*20+HEIGHT*5);
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y+5, DESCRIPTION_TOP+STEP_Y*19.7 + HEIGHT*5);
	contextCairo.show_text("IBAN");
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y+5, DESCRIPTION_TOP+STEP_Y*19.7 + HEIGHT*6);
	contextCairo.show_text("BIC");
	
	contextCairo.select_font_face("Sans-Regular", Cairo.FontSlant.NORMAL, Cairo.FontWeight.NORMAL);
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*15+5, DESCRIPTION_TOP+STEP_Y*19.7 + HEIGHT*2);
	contextCairo.show_text("Groupe CIPL");
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*15+5, DESCRIPTION_TOP+STEP_Y*19.7 + HEIGHT*3);
	contextCairo.show_text("BANQUE POPULAIRE OCCITANE-31135-BALMA-CEDEX");
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*15+5, DESCRIPTION_TOP+STEP_Y*19.7 + HEIGHT*4);
	contextCairo.show_text("17807 00048 95321437163 72");
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*15+5, DESCRIPTION_TOP+STEP_Y*19.7 + HEIGHT*5);
	contextCairo.show_text("FR76 1780 70000 4895 3214 3716 372");
	
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*15+5, DESCRIPTION_TOP+STEP_Y*19.7 + HEIGHT*6);
	contextCairo.show_text("CCBPFRPPTLS");
	
	contextCairo.set_font_size(8);
	contextCairo.move_to(MARGIN_LEFT+STEP_Y*3, DESCRIPTION_TOP+STEP_Y*31);
	contextCairo.show_text("SAS au capital de 1 500 000 € - Siret : 717 220 883 00044 - TVA intracommunautaire FR 28 717 220 883 - Code APE 6820B");
	
	contextCairo.set_font_size(10);
	contextCairo.move_to(MARGIN_LEFT+STEP_Y, DESCRIPTION_TOP+STEP_Y*32);
	contextCairo.show_text("Siège Social : \"La Louve\" 6 route d'Agde - 31 590 Saint Marcel Paulel - Tel : 06.07.04.69.28 - Email : contact@cipl.fr");
	
	contextCairo.stroke();
	
	contextCairo.show_page();
	return 0;
}
