using Gtk;

using BillingType;
using Customer;
using Billing;

public class BillingManagement: Gtk.Window {
	// Declaration des attributs
	private Gtk.MenuBar menuBar;
	
	private Gtk.MenuItem menuItemFile;
	private Gtk.Menu menuFile;
	private Gtk.MenuItem menuItemBillingPreview;
	private Gtk.MenuItem menuItemBillingPrint;
	private Gtk.MenuItem menuItemQuit;
	
	private Gtk.MenuItem menuItemSociety;
	private Gtk.Menu menuSociety;
	private Gtk.MenuItem menuItemLoadDataSociety;
	private Gtk.MenuItem menuItemEditDataSociety;
	private Gtk.MenuItem menuItemSaveDataSociety;
	
	private Gtk.MenuItem menuItemCustomer;
	private Gtk.Menu menuCustomer;
	private Gtk.MenuItem menuItemAddCustomer;
	private Gtk.MenuItem menuItemEditCustomer;
	private Gtk.MenuItem menuItemDeleteCustomer;
	private Gtk.MenuItem menuItemSaveDataCustomer;
	private Gtk.MenuItem menuItemLoadDataCustomer;
	
	private Gtk.MenuItem menuItemHelp;
	
	
	private Gtk.ListStore listStore;
	
	private Gtk.Grid grid;
	
	private Gtk.Label labelInfo;
	
	private string pathDirectory;
	private string pathConfig;
	private string pathDBCustomer;
	
	private CustomerByMonth customerByMonth;
	
	private Customer.AddCustomer addC;
	private Customer.DeleteCustomer delC;
	private Customer.EditCustomer editC;
	private Billing.Billing billing;
	
	
	// Declaration des methodes
	public void copy_file(string namesrc, string namedest) {
		File fileSrc = File.new_for_path(namesrc);
		File fileDest = File.new_for_path(namedest);
		try
		{
			fileSrc.copy(fileDest, 0, null, null);
		}
		catch (Error e)
		{
			print("Error : %s\n", e.message);
		}
	}//end copy_file
	
	public void modif_file(string mfile, string firstWord, string secondWord) {
		File fichierTmp = File.new_for_path("tmp.txt"); // pour ecrire
		File fichierOrig = File.new_for_path(mfile); // pour lire
		
		try
		{
			// pour fichier origine en lecture
			FileInputStream @is = fichierOrig.read();
			DataInputStream dis = new DataInputStream(@is);
			
			// pour fichier temporaire en ecriture
			FileOutputStream @fos = fichierTmp.create(FileCreateFlags.PRIVATE);
			
			string line;
			
			while ( (line = dis.read_line()) != null ) {
				string []tab = line.split(" ");
				string newLine;
				
				if ( tab[0] == firstWord ) {
					newLine = tab[0].concat(" ", secondWord, "\n");
				} else {
					newLine = line.concat("\n");
				}//end if
				
				fos.write(newLine.data);		
			}//end while
			
		}
		catch (Error e) 
		{
			print("Erreur : %s\n", e.message);
		}
	} //end modif_file
	
	public string return_value(string fileconfig, string varapp) {
		File f = File.new_for_path(fileconfig);
		string val = null; //valeur retour
		string line;
		
		try {
			FileInputStream @fis = f.read();
			DataInputStream dis = new DataInputStream(@fis);
			while ( (line = dis.read_line()) != null ) {
				string[] tab = line.split(" ");
				if ( tab[0] == varapp ) {
					val = tab[1];
				}
			}//end while
		} catch (Error e) {
			print("Error : %s\n", e.message);
		}//end try catch
		return val;
	}//end return_value

/*
 * Read file config and
 * Load all data in the main view
 */
	public int load_init_data() {
		File fileConfig = File.new_for_path("tenant.conf"); // repertoire a modifier plus tard
		this.pathDirectory = fileConfig.get_parent().get_path();
		this.pathConfig = fileConfig.get_path();
		print("Chemin du repertoire : %s\n", this.pathDirectory);
		print("Chemin du fichier : %s\n", this.pathConfig);
		bool test = fileConfig.query_exists();
		if (test==true) {
			print("tenant.conf existe!\n");
			this.pathDBCustomer = return_value(this.pathConfig, "FILE_TENANT");
		} else {
			print(" tenant.conf n'existe pas!\n Creation du fichier de configuration!\n");
			this.pathDBCustomer = "default_customer.db";
			try {
				FileOutputStream fos = fileConfig.create(FileCreateFlags.PRIVATE);
				fos.write("FILE_TENANT default_customer.db\n".data);
			} catch (Error e) {
				print("Error : %s\n", e.message);
			}//end try
		}//end if
		
		addC.set_path_database_customer(this.pathDBCustomer);
		
		if (addC.file_dbcustomer_exist() ==true) {
			print("La base de donnee : %s existe!\n", this.pathDBCustomer);
			this.delC.set_path_database_customer(this.pathDBCustomer);
			this.editC.set_path_database_customer(this.pathDBCustomer);
		} else {
			print("Tentative de creation de la base de donnee %s\n", this.pathDBCustomer);
			var res = addC.create_database();
			if ( res == 0 ) {
				print("La base de donne a ete cree\n");
				this.delC.set_path_database_customer(this.pathDBCustomer);
				this.editC.set_path_database_customer(this.pathDBCustomer);
			} else {
				print("Probleme dans la creation de la base de donnee\n");
			}//end if res
		}//end if file_dbcustomer_exist
		print("Contenu de pathDBCustomer : %s\n", this.pathDBCustomer);

		this.customerByMonth = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
		var res = this.refresh_main_view();
		if (res!=0) {
			print("Erreur de rafraichissement de la vue principale!\n");
		}
				
		return 0;
	}//end load_init_data
	
	public int refresh_main_view() {
		// Delete all old widget of grid
		foreach (Gtk.Widget element in this.grid.get_children())
			this.grid.remove(element);
		
		// init all month at 0	
		increment_month(-1, ref this.customerByMonth);
		
		var cssprovider = new Gtk.CssProvider();
		this.grid.set_column_spacing(0);
		
		// Display Info grid
		var labelNameCustomer = new Gtk.Label("Nom des locataires");
		labelNameCustomer.set_hexpand(false);
		this.grid.attach(labelNameCustomer, 0, 0, 1, 1);
		
		var buttonJanuary = new Gtk.Button.with_label("Janvier");
		buttonJanuary.set_hexpand(true);
		this.grid.attach(buttonJanuary, 1, 0, 1, 1);
		
		var buttonFebruary = new Gtk.Button.with_label("Février");
		buttonFebruary.set_hexpand(true);
		this.grid.attach(buttonFebruary, 2, 0, 1, 1);
		
		var buttonMarch = new Gtk.Button.with_label("Mars");
		buttonMarch.set_hexpand(true);
		this.grid.attach(buttonMarch, 3, 0, 1, 1);
		
		var buttonApril = new Gtk.Button.with_label("Avril");
		buttonApril.set_hexpand(true);
		this.grid.attach(buttonApril, 4, 0, 1, 1);
		
		var buttonMay = new Gtk.Button.with_label("Mai");
		buttonMay.set_hexpand(true);
		this.grid.attach(buttonMay, 5, 0, 1, 1);
		
		var buttonJune = new Gtk.Button.with_label("Juin");
		buttonJune.set_hexpand(true);
		this.grid.attach(buttonJune, 6, 0, 1, 1);
		
		var buttonJuly = new Gtk.Button.with_label("Juillet");
		buttonJuly.set_hexpand(true);
		this.grid.attach(buttonJuly, 7, 0, 1, 1);
		
		var buttonAugust = new Gtk.Button.with_label("Août");
		buttonAugust.set_hexpand(true);
		this.grid.attach(buttonAugust, 8, 0, 1, 1);
		
		var buttonSeptember = new Gtk.Button.with_label("Septembre");
		buttonSeptember.set_hexpand(true);
		this.grid.attach(buttonSeptember, 9, 0, 1, 1);
		
		var buttonOctober = new Gtk.Button.with_label("Octobre");
		buttonOctober.set_hexpand(true);
		this.grid.attach(buttonOctober, 10, 0, 1, 1);
		
		var buttonNovember = new Gtk.Button.with_label("Novembre");
		buttonNovember.set_hexpand(true);
		this.grid.attach(buttonNovember, 11, 0, 1, 1);
		
		var buttonDecember = new Gtk.Button.with_label("Décembre");
		buttonDecember.set_hexpand(true);
		this.grid.attach(buttonDecember, 12, 0, 1, 1);
		
		
		addC.select_table_customer();
//		addC.display_list_data_customer();
		
		int nbCustomer = addC.get_number_customer();
		DataCustomer c;
		
		this.labelInfo.set_text("Nombre de Locataire "+nbCustomer.to_string());
		
		Periodicity periodicity;
		List <DateMonth> listPeriodicity;
		
		int nbC = 0;
		// Display new widget in grid
		for (int i=0;i<nbCustomer;i++) {
			c = addC.get_data_customer(i);
			
			periodicity = this.billing.get_periodicity(c.RentPeriodicity);

			DateMonth dmRentReview = this.billing.convert_string_to_date_month(c.RentReview);
			listPeriodicity = this.billing.get_list_months_billable(periodicity, dmRentReview);

			var buttonC = new Gtk.Button.with_label(c.CompanyName);
buttonC.set_vexpand(false);
buttonC.set_hexpand(false);
buttonC.set_size_request(140,8);
			this.grid.attach(buttonC, 0, i+1, 1, 1);
			
			nbC = i;
			DataCustomer cCopy = c;
			buttonC.clicked.connect( () => {
				this.editC.show_edit_customer(cCopy);
				print("numero locataire : %d\n", nbC);
			});
			
			print("Nom %s\n", c.CompanyName);
			switch (periodicity) {
				case Periodicity.MONTHLY:
					print("Mensuelle\n");
					increment_month(13, ref this.customerByMonth); // parameter 13 increment all month
					foreach (DateMonth month in listPeriodicity) {
						var buttonX = new Gtk.Button.with_label("X");
						try {
							cssprovider.load_from_path("tenant.css");
							buttonX.get_style_context().add_provider(cssprovider, Gtk.STYLE_PROVIDER_PRIORITY_USER);
						} catch (Error e) {
							error("Erreur : %s\n", e.message);
						}
						this.grid.attach(buttonX, month, i+1, 1, 1);
						buttonX.clicked.connect( () => {
							this.billing.set_data_customer(cCopy, month);
							this.billing.show_billing();
							this.billing.present();
						});
					}
					break;
				case Periodicity.QUARTERLY:
					print("Trimestrielle\n");
					print("Revision loyer de %s : %s %d\n", c.CompanyName, c.RentReview, dmRentReview);
					foreach (DateMonth month in listPeriodicity) {
						print("mois =%d\n", month);
						increment_month(month, ref this.customerByMonth);
						var buttonX = new Gtk.Button.with_label("X");
						try {
							cssprovider.load_from_path("tenant.css");
							buttonX.get_style_context().add_provider(cssprovider, Gtk.STYLE_PROVIDER_PRIORITY_USER);
						} catch (Error e) {
							error("Erreur : %s\n", e.message);
						}
						this.grid.attach(buttonX, month, i+1, 1, 1);
						buttonX.clicked.connect( () => {
							this.billing.set_data_customer(cCopy, month);
							this.billing.show_billing();
							this.billing.present();
						});

					//	print("Mois %d\n", month);
					}
					break;
				case Periodicity.BIANNUAL:
					print("Annuel\n");
					foreach (DateMonth month in listPeriodicity) {
						increment_month(month, ref this.customerByMonth);
						display_customer_by_month(this.customerByMonth);
						var buttonX = new Gtk.Button.with_label("X");
						try {
							cssprovider.load_from_path("tenant.css");
							buttonX.get_style_context().add_provider(cssprovider, Gtk.STYLE_PROVIDER_PRIORITY_USER);
						} catch (Error e) {
							error("Erreur : %s\n", e.message);
						}
						this.grid.attach(buttonX, month, i+1, 1, 1);
						buttonX.clicked.connect( () => {
							this.billing.set_data_customer(cCopy, month);
							this.billing.show_billing();
							this.billing.present();
						});
					}
					break;
				case Periodicity.BAD:
					print("Pas normal\n");
					break;
			}
			
			var labelQ = new Gtk.Label(c.RentReview);
			this.grid.attach(labelQ, 13, i+1, 1, 1);
//			print("Test CompanyName = %s\n", c.CompanyName);
		}//end for
		string snbC = (nbC+1).to_string();
		print("snbC = %s\n", snbC);
		var labelTotalC = new Gtk.Label("Total factures");
		this.grid.attach(labelTotalC, 0, nbC+3, 1, 1);
		
		string sJan = this.customerByMonth.january.to_string();
		var labelJan = new Gtk.Label(sJan);
		this.grid.attach(labelJan, 1, nbC+3, 1, 1);
		
		string sFeb = this.customerByMonth.february.to_string();
		var labelFeb = new Gtk.Label(sFeb);
		this.grid.attach(labelFeb, 2, nbC+3, 1, 1);
		
		string sMar = this.customerByMonth.march.to_string();
		var labelMar = new Gtk.Label(sMar);
		this.grid.attach(labelMar, 3, nbC+3, 1, 1);
		
		string sApr = this.customerByMonth.april.to_string();
		var labelApr = new Gtk.Label(sApr);
		this.grid.attach(labelApr, 4, nbC+3, 1, 1);
		
		string sMay = this.customerByMonth.may.to_string();
		var labelMay = new Gtk.Label(sMay);
		this.grid.attach(labelMay, 5, nbC+3, 1, 1);
		
		string sJun = this.customerByMonth.june.to_string();
		var labelJun = new Gtk.Label(sJun);
		this.grid.attach(labelJun, 6, nbC+3, 1, 1);
		
		string sJul = this.customerByMonth.july.to_string();
		var labelJul = new Gtk.Label(sJul);
		this.grid.attach(labelJul, 7, nbC+3, 1, 1);
		
		string sAug = this.customerByMonth.august.to_string();
		var labelAug = new Gtk.Label(sAug);
		this.grid.attach(labelAug, 8, nbC+3, 1, 1);
		
		string sSep = this.customerByMonth.september.to_string();
		var labelSep = new Gtk.Label(sSep);
		this.grid.attach(labelSep, 9, nbC+3, 1, 1);
		
		string sOct = this.customerByMonth.october.to_string();
		var labelOct = new Gtk.Label(sOct);
		this.grid.attach(labelOct, 10, nbC+3, 1, 1);
		
		string sNov = this.customerByMonth.november.to_string();
		var labelNov = new Gtk.Label(sNov);
		this.grid.attach(labelNov, 11, nbC+3, 1, 1);
		
		string sDec = this.customerByMonth.december.to_string();
		var labelDec = new Gtk.Label(sDec);
		this.grid.attach(labelDec, 12, nbC+3, 1, 1);
		
		return 0;
	}//end refresh_main_view
	
	/*
	 * Constructor BillingManagement
	 */
	public BillingManagement() {
		this.destroy.connect(Gtk.main_quit);
		this.title = "Gestion des Locataires";
		this.addC = new Customer.AddCustomer();
		this.delC = new Customer.DeleteCustomer();
		this.editC = new Customer.EditCustomer();
		this.billing = new Billing.Billing();

		// File Menu
		this.menuFile = new Gtk.Menu();
		this.menuItemBillingPreview = new Gtk.MenuItem.with_label("Aperçu Factures");
		this.menuFile.add(this.menuItemBillingPreview);
		this.menuItemBillingPrint = new Gtk.MenuItem.with_label("Imprimer Factures");
		this.menuFile.add(this.menuItemBillingPrint);
		this.menuItemQuit = new Gtk.MenuItem.with_label("Quitter");
		this.menuFile.add(this.menuItemQuit);
		
		// File Society
		this.menuSociety = new Gtk.Menu();
		this.menuItemLoadDataSociety = new Gtk.MenuItem.with_label("Charger donnée");
		this.menuSociety.add(this.menuItemLoadDataSociety);
		this.menuItemEditDataSociety = new Gtk.MenuItem.with_label("Modification donnée");
		this.menuSociety.add(this.menuItemEditDataSociety);
		this.menuItemSaveDataSociety = new Gtk.MenuItem.with_label("Sauver donnée");
		this.menuSociety.add(this.menuItemSaveDataSociety);
		
		// File Customer
		this.menuCustomer = new Gtk.Menu();
		this.menuItemAddCustomer = new Gtk.MenuItem.with_label("Ajouter Locataire");
		this.menuCustomer.add(this.menuItemAddCustomer);
		this.menuItemEditCustomer = new Gtk.MenuItem.with_label("Modification Locataire");
		this.menuCustomer.add(this.menuItemEditCustomer);
		this.menuItemDeleteCustomer = new Gtk.MenuItem.with_label("Suppression Locataire");
		this.menuCustomer.add(this.menuItemDeleteCustomer);
		this.menuItemSaveDataCustomer = new Gtk.MenuItem.with_label("Enregistrer Données Locataires");
		this.menuCustomer.add(this.menuItemSaveDataCustomer);
		this.menuItemLoadDataCustomer = new Gtk.MenuItem.with_label("Charger Données Locataires");
		this.menuCustomer.add(this.menuItemLoadDataCustomer);
		
		// Main Menu
		this.menuBar = new Gtk.MenuBar();
		this.menuItemFile = new Gtk.MenuItem.with_label("Fichier");
		this.menuItemFile.set_submenu(this.menuFile);
		this.menuBar.add(this.menuItemFile);
		
		this.menuItemSociety = new Gtk.MenuItem.with_label("Société");
		this.menuItemSociety.set_submenu(this.menuSociety);
		this.menuBar.add(this.menuItemSociety);
		
		this.menuItemCustomer = new Gtk.MenuItem.with_label("Locataires");
		this.menuItemCustomer.set_submenu(this.menuCustomer);
		this.menuBar.add(this.menuItemCustomer);
		
		this.menuItemHelp = new Gtk.MenuItem.with_label("Aide");
		this.menuBar.add(this.menuItemHelp);
		
		// grid - main view
		this.grid = new Gtk.Grid();
//		this.grid.set_column_spacing(20);
		this.grid.set_hexpand(true);

		this.labelInfo = new Gtk.Label("Demarrage Application!");

		/*
		 * Init Data
		 */
		int result = this.load_init_data();
		print("Initialisation des donnees : %d\n", result);
				
		/*
		 * Signal connect
		 */
		this.menuItemQuit.activate.connect( () => {
			Gtk.main_quit();
		});
		
		this.menuItemAddCustomer.activate.connect( () => {
			print("Ajout d'un locataire\n");
			this.addC.clear_entry();
			this.addC.show_add_customer();
		});
		
		this.menuItemDeleteCustomer.activate.connect( () => {
			this.delC.refresh_view_delete_customer();
			this.delC.show_delete_customer();
		});
		
		this.addC.buttonAddCustomer.clicked.connect( ()=> {
			print("Buttton addC\n");
			this.refresh_main_view();
			this.grid.show_all();
		});
		
		this.delC.buttonDelete.clicked.connect( () => {
			this.refresh_main_view();
			this.grid.show_all();
		});
		
		this.menuItemSaveDataCustomer.activate.connect( ()=> {
			print("Sauvegarde d'un locataire\n");
			var saveC = new Customer.SaveCustomer();
			print("Fichier enregistre : %s\n", saveC.get_path_database_customer());
		});
		
//		this.labelInfo = new Gtk.Label("Demarrage Application!");
		
//		labelInfo.set_vexpand(true);
//		labelInfo.set_margin_bottom(1);
		
//		this.load_init_data();
		
		
		// box (place les differents elements graphiques)
		Gtk.Box boxMain = new Gtk.Box(Gtk.Orientation.VERTICAL, 0);
		boxMain.pack_start(this.menuBar, false, false, 0);
		boxMain.pack_start(this.grid, true, true, 8);
		boxMain.pack_start(labelInfo, false, false, 0);
		this.add(boxMain);
	}//end constructor BillingManagement
	
	public static int main(string[] args) {
		Gtk.init(ref args);
		var bm = new BillingManagement();
		bm.show_all();
		Gtk.main();
		return 0;
	}//end main
}//end class BillingManagement
